/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.viewer;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.viewer.ViewerAttributeRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ViewerConfigDialog
extends Dialog {
    private static final String[] inverseSearchValues = new String[]{"no", "run", "std"};
    protected File lastPath;
    private Text fileField;
    private Text nameField;
    private Text argsField;
    private DDEGroup ddeViewGroup;
    private DDEGroup ddeCloseGroup;
    private Combo formatChooser;
    private Combo inverseChooser;
    private Label statusField;
    private ViewerAttributeRegistry registry;
    private ArrayList nameList;
    private boolean newConfig;
    private Button forwardChoice;

    public ViewerConfigDialog(Shell parentShell, ViewerAttributeRegistry reg) {
        super(parentShell);
        this.registry = reg;
        this.newConfig = false;
    }

    public ViewerConfigDialog(Shell parentShell, ArrayList nameList) {
        super(parentShell);
        this.registry = new ViewerAttributeRegistry();
        this.registry.setActiveViewer("none");
        this.nameList = nameList;
        this.newConfig = true;
    }

    protected void setStatus(String key, String info) {
        String msg = "";
        if (key != null && key.length() > 0 && (msg = TexlipsePlugin.getResourceString(key)).indexOf("%s") >= 0) {
            msg = msg.replaceAll("%s", info);
        }
        this.statusField.setText(msg);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.newConfig) {
            newShell.setText(TexlipsePlugin.getResourceString("preferenceViewerDialogAddTitle"));
        } else {
            newShell.setText(TexlipsePlugin.getResourceString("preferenceViewerDialogEditTitle"));
        }
    }

    public ViewerAttributeRegistry getRegistry() {
        return this.registry;
    }

    protected void okPressed() {
        if (!this.validateFields()) {
            return;
        }
        String name = this.nameField.getText();
        this.registry.setActiveViewer(this.nameField.getText());
        this.registry.setCommand(this.fileField.getText());
        this.registry.setArguments(this.argsField.getText());
        this.registry.setDDEViewCommand(this.ddeViewGroup.command.getText());
        this.registry.setDDEViewServer(this.ddeViewGroup.server.getText());
        this.registry.setDDEViewTopic(this.ddeViewGroup.topic.getText());
        this.registry.setDDECloseCommand(this.ddeCloseGroup.command.getText());
        this.registry.setDDECloseServer(this.ddeCloseGroup.server.getText());
        this.registry.setDDECloseTopic(this.ddeCloseGroup.topic.getText());
        this.registry.setFormat(this.formatChooser.getItem(this.formatChooser.getSelectionIndex()));
        this.registry.setInverse(inverseSearchValues[this.inverseChooser.getSelectionIndex()]);
        this.registry.setForward(this.forwardChoice.getSelection());
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfigurationType type;
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            if (manager != null && (type = manager.getLaunchConfigurationType("net.sourceforge.texlipse.viewer.launchConfigurationType")) != null && (configs = manager.getLaunchConfigurations(type)) != null) {
                int returnCode = 0;
                MessageDialogWithToggle md = null;
                int i = 0;
                while (i < configs.length) {
                    ILaunchConfiguration c = configs[i];
                    if (c.getType().getIdentifier().equals("net.sourceforge.texlipse.viewer.launchConfigurationType") && c.getAttribute("viewerCurrent", "").equals(name)) {
                        if (returnCode == 0) {
                            String message = MessageFormat.format(TexlipsePlugin.getResourceString("preferenceViewerUpdateConfigurationQuestion"), c.getName());
                            md = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)this.getShell(), (String)TexlipsePlugin.getResourceString("preferenceViewerUpdateConfigurationTitle"), (String)message, (String)TexlipsePlugin.getResourceString("preferenceViewerUpdateConfigurationAlwaysApply"), (boolean)false, null, null);
                            if (md.getReturnCode() == 1) {
                                return;
                            }
                            returnCode = md.getReturnCode();
                        }
                        if (returnCode == 2) {
                            ILaunchConfigurationWorkingCopy workingCopy = c.getWorkingCopy();
                            workingCopy.setAttributes(this.registry.asMap());
                            workingCopy.setAttribute("viewerCurrent", name);
                            workingCopy.doSave();
                        }
                        if (!md.getToggleState()) {
                            returnCode = 0;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        this.setReturnCode(0);
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = (GridLayout)composite.getLayout();
        gl.numColumns = 2;
        Label descrLabel = new Label(composite, 16384);
        descrLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerDescriptionLabel"));
        GridData dgd = new GridData(768);
        dgd.horizontalSpan = 2;
        descrLabel.setLayoutData((Object)dgd);
        this.addConfigNameField(composite);
        this.addFileBrowser(composite);
        this.addArgumentsField(composite);
        this.addDDEGroups(composite);
        this.addFormatChooser(composite);
        this.addInverseChooser(composite);
        this.addForwardChooser(composite);
        Group group = new Group(composite, 4);
        group.setLayoutData((Object)new GridData(768));
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout());
        this.statusField = new Label((Composite)group, 16384);
        this.statusField.setLayoutData((Object)new GridData(768));
        this.statusField.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerStatusTooltip"));
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control ctrl = super.createButtonBar(parent);
        this.validateFields();
        return ctrl;
    }

    private boolean validateFields() {
        boolean everythingOK = true;
        String name = this.nameField.getText();
        if (this.nameField.getText() == null || this.nameField.getText().length() == 0) {
            this.setStatus("preferenceViewerDialogNameEmpty", "");
            everythingOK = false;
        }
        if (this.formatChooser.getSelectionIndex() == -1) {
            this.setStatus("preferenceViewerFormatEmpty", "");
            everythingOK = false;
        }
        if (this.nameList != null && this.nameList.contains(name)) {
            this.setStatus("preferenceViewerDialogNameExists", name);
            everythingOK = false;
        }
        File f = new File(this.fileField.getText());
        if (this.fileField.getText().trim().equals("")) {
            this.setStatus("preferenceViewerDialogFileNoFile", "");
            everythingOK = false;
        } else if (!f.exists()) {
            this.setStatus("preferenceViewerDialogFileNotFound", "");
            everythingOK = false;
        }
        if (!everythingOK) {
            Button b = this.getButton(0);
            if (b != null) {
                b.setEnabled(false);
            }
            return false;
        }
        Button b = this.getButton(0);
        if (b != null) {
            b.setEnabled(true);
        }
        this.setStatus("preferenceViewerDialogFileOk", "");
        return true;
    }

    private void addConfigNameField(Composite composite) {
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerNameLabel"));
        nameLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerNameTooltip"));
        nameLabel.setLayoutData((Object)new GridData());
        int rw = this.newConfig ? 0 : 8;
        this.nameField = new Text(composite, 0x804 | rw);
        this.nameField.setText(this.registry.getActiveViewer());
        this.nameField.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerNameTooltip"));
        this.nameField.setLayoutData((Object)new GridData(768));
    }

    private void addFileBrowser(Composite composite) {
        Label fileLabel = new Label(composite, 16384);
        fileLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerCommandLabel"));
        fileLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerCommandTooltip"));
        fileLabel.setLayoutData((Object)new GridData());
        Composite browser = new Composite(composite, 0);
        browser.setLayoutData((Object)new GridData(768));
        GridLayout bgl = new GridLayout();
        bgl.numColumns = 2;
        browser.setLayout((Layout)bgl);
        this.fileField = new Text(browser, 2052);
        this.fileField.setText(this.registry.getCommand());
        this.fileField.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerCommandTooltip"));
        this.fileField.setLayoutData((Object)new GridData(768));
        this.fileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ViewerConfigDialog.this.validateFields();
            }
        });
        Button browseButton = new Button(browser, 8);
        browseButton.setText(JFaceResources.getString((String)"openBrowse"));
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String dir;
                FileDialog dialog = new FileDialog(ViewerConfigDialog.this.getShell());
                if (ViewerConfigDialog.this.lastPath != null) {
                    if (ViewerConfigDialog.this.lastPath.exists()) {
                        dialog.setFilterPath(ViewerConfigDialog.this.lastPath.getAbsolutePath());
                    }
                } else {
                    ViewerConfigDialog.this.lastPath = new File(ViewerConfigDialog.this.fileField.getText());
                    while (ViewerConfigDialog.this.lastPath != null && !ViewerConfigDialog.this.lastPath.isDirectory()) {
                        ViewerConfigDialog.this.lastPath = ViewerConfigDialog.this.lastPath.getParentFile();
                    }
                    if (ViewerConfigDialog.this.lastPath != null && ViewerConfigDialog.this.lastPath.exists()) {
                        dialog.setFilterPath(ViewerConfigDialog.this.lastPath.getAbsolutePath());
                    }
                }
                if ((dir = dialog.open()) != null) {
                    ViewerConfigDialog.this.lastPath = new File(dir.trim());
                    if (ViewerConfigDialog.this.lastPath.exists()) {
                        ViewerConfigDialog.this.fileField.setText(ViewerConfigDialog.this.lastPath.getAbsolutePath());
                        ViewerConfigDialog.this.registry.setCommand(ViewerConfigDialog.this.fileField.getText());
                    } else {
                        ViewerConfigDialog.this.lastPath = null;
                    }
                }
            }
        });
    }

    private void addArgumentsField(Composite composite) {
        Label argsLabel = new Label(composite, 16384);
        argsLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerArgumentLabel"));
        argsLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerArgumentTooltip"));
        argsLabel.setLayoutData((Object)new GridData());
        this.argsField = new Text(composite, 2052);
        this.argsField.setText(this.registry.getArguments());
        this.argsField.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerArgumentTooltip"));
        this.argsField.setLayoutData((Object)new GridData(768));
    }

    private void addDDEGroups(Composite composite) {
        this.ddeViewGroup = new DDEGroup(composite, TexlipsePlugin.getResourceString("preferenceViewerDDEViewLabel"), TexlipsePlugin.getResourceString("preferenceViewerDDEViewTooltip"));
        this.ddeViewGroup.command.setText(this.registry.getDDEViewCommand());
        this.ddeViewGroup.server.setText(this.registry.getDDEViewServer());
        this.ddeViewGroup.topic.setText(this.registry.getDDEViewTopic());
        this.ddeCloseGroup = new DDEGroup(composite, TexlipsePlugin.getResourceString("preferenceViewerDDECloseLabel"), TexlipsePlugin.getResourceString("preferenceViewerDDECloseTooltip"));
        this.ddeCloseGroup.command.setText(this.registry.getDDECloseCommand());
        this.ddeCloseGroup.server.setText(this.registry.getDDECloseServer());
        this.ddeCloseGroup.topic.setText(this.registry.getDDECloseTopic());
        if (Platform.getOS().equals("win32")) {
            this.ddeViewGroup.setVisible(true);
            this.ddeCloseGroup.setVisible(true);
        }
    }

    private void addFormatChooser(Composite composite) {
        Label formatLabel = new Label(composite, 16384);
        formatLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerFormatLabel"));
        formatLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerFormatTooltip"));
        formatLabel.setLayoutData((Object)new GridData());
        this.formatChooser = new Combo(composite, 12);
        this.formatChooser.setLayoutData((Object)new GridData());
        this.formatChooser.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerFormatTooltip"));
        this.formatChooser.setItems(this.registry.getFormatList());
        this.formatChooser.select(this.formatChooser.indexOf(this.registry.getFormat()));
    }

    private void addInverseChooser(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(TexlipsePlugin.getResourceString("preferenceViewerInverseLabel"));
        label.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerInverseTooltip"));
        label.setLayoutData((Object)new GridData());
        String[] list = new String[]{TexlipsePlugin.getResourceString("preferenceViewerInverseSearchNo"), TexlipsePlugin.getResourceString("preferenceViewerInverseSearchRun"), TexlipsePlugin.getResourceString("preferenceViewerInverseSearchStd")};
        int index = inverseSearchValues.length - 1;
        while (index > 0 && !inverseSearchValues[index].equals(this.registry.getInverse())) {
            --index;
        }
        this.inverseChooser = new Combo(parent, 12);
        this.inverseChooser.setLayoutData((Object)new GridData());
        this.inverseChooser.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerInverseTooltip"));
        this.inverseChooser.setItems(list);
        this.inverseChooser.select(index);
    }

    private void addForwardChooser(Composite parent) {
        this.forwardChoice = new Button(parent, 32);
        this.forwardChoice.setText(TexlipsePlugin.getResourceString("preferenceViewerForwardLabel"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.forwardChoice.setLayoutData((Object)gd);
        this.forwardChoice.setSelection(this.registry.getForward());
    }

    private class DDEGroup
    extends Composite {
        public Text command;
        public Text server;
        public Text topic;

        public DDEGroup(Composite parent, String name, String toolTip) {
            super(parent, 0);
            this.setLayoutData(new GridData(768));
            ((GridData)this.getLayoutData()).horizontalSpan = 2;
            this.setLayout((Layout)new GridLayout());
            Group group = new Group((Composite)this, 4);
            group.setText(name);
            group.setToolTipText(toolTip);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(4, false));
            Label ddeCommandLabel = new Label((Composite)group, 16384);
            ddeCommandLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerDDECommandLabel"));
            ddeCommandLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDECommandTooltip"));
            ddeCommandLabel.setLayoutData((Object)new GridData());
            this.command = new Text((Composite)group, 2052);
            this.command.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDECommandTooltip"));
            this.command.setLayoutData((Object)new GridData(768));
            ((GridData)this.command.getLayoutData()).horizontalSpan = 3;
            Label ddeServerLabel = new Label((Composite)group, 16384);
            ddeServerLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerDDEServerLabel"));
            ddeServerLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDEServerTooltip"));
            ddeServerLabel.setLayoutData((Object)new GridData());
            this.server = new Text((Composite)group, 2052);
            this.server.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDEServerTooltip"));
            this.server.setLayoutData((Object)new GridData(768));
            Label ddeTopicLabel = new Label((Composite)group, 16384);
            ddeTopicLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerDDETopicLabel"));
            ddeTopicLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDETopicTooltip"));
            ddeTopicLabel.setLayoutData((Object)new GridData());
            this.topic = new Text((Composite)group, 2052);
            this.topic.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDETopicTooltip"));
            this.topic.setLayoutData((Object)new GridData(768));
            this.setVisible(false);
        }
    }
}

