/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.bibparser.BibParser;
import net.sourceforge.texlipse.builder.KpsewhichRunner;
import net.sourceforge.texlipse.editor.TexDocumentParseException;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.model.DocumentReference;
import net.sourceforge.texlipse.model.MarkerHandler;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.model.ParseErrorMessage;
import net.sourceforge.texlipse.model.ReferenceContainer;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.model.ReferenceManager;
import net.sourceforge.texlipse.model.TexCommandContainer;
import net.sourceforge.texlipse.model.TexCommandEntry;
import net.sourceforge.texlipse.model.TexOutlineInput;
import net.sourceforge.texlipse.model.TexProjectParser;
import net.sourceforge.texlipse.outline.TexOutlinePage;
import net.sourceforge.texlipse.outline.TexProjectOutline;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.texparser.LatexRefExtractingParser;
import net.sourceforge.texlipse.texparser.TexParser;
import net.sourceforge.texlipse.treeview.views.TexOutlineTreeView;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexDocumentModel
implements IDocumentListener {
    public static final String PARSER_FAMILY = "TexDocument Parser";
    private TexEditor editor;
    private TexParser parser;
    private TexProjectOutline projectOutline;
    private TexOutlineInput outlineInput;
    private ReferenceContainer bibContainer;
    private ReferenceContainer labelContainer;
    private TexCommandContainer commandContainer;
    private ReferenceManager refMana;
    private boolean firstRun = true;
    private static ILock lock = Job.getJobManager().newLock();
    private boolean isDirty;
    private ParseJob parseJob;
    private PostParseJob postParseJob;
    private int parseDelay;
    private boolean autoParseEnabled;
    private boolean sectionCheckEnabled;

    public TexDocumentModel(TexEditor editor) {
        this.editor = editor;
        this.isDirty = true;
        this.parseJob = new ParseJob("Parsing");
        this.postParseJob = new PostParseJob("Updating");
        this.parseJob.setPriority(50);
        this.postParseJob.setPriority(50);
        this.parseDelay = TexlipsePlugin.getDefault().getPreferenceStore().getInt("autoParsingDelay");
        this.autoParseEnabled = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("autoParsing");
        this.sectionCheckEnabled = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("sectionCheck");
        TexlipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("autoParsing".equals(property)) {
                    TexDocumentModel.this.autoParseEnabled = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("autoParsing");
                } else if ("autoParsingDelay".equals(property)) {
                    TexDocumentModel.this.parseDelay = TexlipsePlugin.getDefault().getPreferenceStore().getInt("autoParsingDelay");
                } else if ("sectionCheck".equals(property)) {
                    TexDocumentModel.this.sectionCheckEnabled = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("sectionCheck");
                }
            }
        });
    }

    public void initializeModel() {
        MarkerHandler.getInstance().clearErrorMarkers((ITextEditor)this.editor);
        MarkerHandler.getInstance().clearTaskMarkers((ITextEditor)this.editor);
        this.createReferenceContainers();
    }

    public void updateNow() {
        this.parseJob.cancel();
        this.parseJob.schedule();
    }

    public void updateOutline() {
        if (!this.isDirty()) {
            this.editor.getOutlinePage().update(this.outlineInput);
        } else {
            this.updateNow();
        }
    }

    public ReferenceManager getRefMana() {
        if (this.refMana == null) {
            if (this.bibContainer == null) {
                this.createReferenceContainers();
            }
            this.refMana = new ReferenceManager(this.bibContainer, this.labelContainer, this.commandContainer);
        }
        return this.refMana;
    }

    public synchronized boolean isDirty() {
        return this.isDirty;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        TexOutlineTreeView fullOutline;
        try {
            lock.acquire();
            this.parseJob.cancel();
            this.setDirty(true);
        }
        finally {
            lock.release();
        }
        TexOutlinePage outline = this.editor.getOutlinePage();
        if (outline != null) {
            this.editor.getOutlinePage().modelGotDirty();
        }
        if ((fullOutline = this.editor.getFullOutline()) != null) {
            fullOutline.modelGotDirty();
        }
        if (this.autoParseEnabled) {
            this.parseJob.schedule(this.parseDelay);
        }
    }

    private void createProjectOutline() {
        IProject project = this.getCurrentProject();
        if (project == null) {
            return;
        }
        Object projectSessionOutLine = TexlipseProperties.getSessionProperty((IResource)project, "project.fullTexParser");
        if (projectSessionOutLine != null) {
            this.projectOutline = (TexProjectOutline)projectSessionOutLine;
        } else {
            this.projectOutline = new TexProjectOutline(this.getCurrentProject());
            TexlipseProperties.setSessionProperty((IResource)project, "project.fullTexParser", this.projectOutline);
        }
    }

    private ArrayList<OutlineNode> doParse(IProgressMonitor monitor) throws TexDocumentParseException {
        if (this.parser == null) {
            this.parser = new TexParser(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()));
        }
        if (this.projectOutline == null) {
            this.createProjectOutline();
        }
        try {
            this.parser.parseDocument(this.sectionCheckEnabled);
        }
        catch (IOException e) {
            TexlipsePlugin.log("Can't read file.", e);
            throw new TexDocumentParseException(e);
        }
        this.pollCancel(monitor);
        List<ParseErrorMessage> errors = this.parser.getErrors();
        List<ParseErrorMessage> tasks = this.parser.getTasks();
        MarkerHandler marker = MarkerHandler.getInstance();
        if (!this.firstRun) {
            marker.clearErrorMarkers((ITextEditor)this.editor);
            marker.clearTaskMarkers((ITextEditor)this.editor);
        } else {
            this.firstRun = false;
        }
        if (this.editor.getProject() != null && this.editor.getFullOutline() != null) {
            IResource res = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
            String fileName = res.getProjectRelativePath().toString();
            this.projectOutline.addOutline(this.parser.getOutlineTree(), fileName);
            List<OutlineNode> fo = this.projectOutline.getFullOutline();
            this.postParseJob.setFONodes(fo);
        } else {
            this.postParseJob.setFONodes(null);
        }
        this.pollCancel(monitor);
        this.processIncludes(this.parser.getInputs(), this.editor.getEditorInput());
        if (errors.size() > 0) {
            marker.createErrorMarkers((ITextEditor)this.editor, errors);
        }
        if (tasks.size() > 0) {
            marker.createTaskMarkers((ITextEditor)this.editor, tasks);
        }
        if (this.parser.isFatalErrors()) {
            throw new TexDocumentParseException("Fatal errors in file, parsing aborted.");
        }
        this.updateReferences(monitor);
        List<DocumentReference> cites = this.parser.getCites();
        ArrayList<DocumentReference> bibErrors = null;
        for (DocumentReference cite : cites) {
            if (this.bibContainer.binTest(cite.getKey())) continue;
            if (bibErrors == null) {
                bibErrors = new ArrayList<DocumentReference>();
            }
            bibErrors.add(cite);
        }
        if (bibErrors != null) {
            marker.createReferencingErrorMarkers((ITextEditor)this.editor, bibErrors);
        }
        List<DocumentReference> refs = this.parser.getRefs();
        ArrayList<DocumentReference> refErrors = null;
        for (DocumentReference ref : refs) {
            if (this.labelContainer.binTest(ref.getKey())) continue;
            if (refErrors == null) {
                refErrors = new ArrayList<DocumentReference>();
            }
            refErrors.add(ref);
        }
        if (refErrors != null) {
            marker.createReferencingErrorMarkers((ITextEditor)this.editor, refErrors);
        }
        return this.parser.getOutlineTree();
    }

    private void updateDocumentPositions(List<OutlineNode> rootNodes, IProgressMonitor monitor) {
        TexOutlineInput newOutlineInput = new TexOutlineInput(rootNodes);
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        try {
            document.removePositionCategory("__outline");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        document.addPositionCategory("__outline");
        this.pollCancel(monitor);
        int maxDepth = 0;
        for (OutlineNode node : rootNodes) {
            int localDepth = this.addNodePosition(node, document, 0, newOutlineInput);
            if (localDepth > maxDepth) {
                maxDepth = localDepth;
            }
            this.pollCancel(monitor);
        }
        this.pollCancel(monitor);
        newOutlineInput.setTreeDepth(maxDepth);
        this.outlineInput = newOutlineInput;
    }

    private int addNodePosition(OutlineNode node, IDocument document, int parentDepth, TexOutlineInput newOutlineInput) {
        int beginOffset = 0;
        int length = 0;
        Position position = null;
        try {
            beginOffset = document.getLineOffset(node.getBeginLine() - 1);
            length = node.getEndLine() - 1 == document.getNumberOfLines() ? document.getLength() - beginOffset : document.getLineOffset(node.getEndLine() - 1) - beginOffset;
            position = new Position(beginOffset, length);
            document.addPosition("__outline", position);
        }
        catch (BadLocationException badLocationException) {
            throw new OperationCanceledException();
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            throw new OperationCanceledException();
        }
        node.setPosition(position);
        newOutlineInput.addNode(node);
        ArrayList<OutlineNode> children = node.getChildren();
        int maxDepth = parentDepth + 1;
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                int localDepth = this.addNodePosition((OutlineNode)iter.next(), document, parentDepth + 1, newOutlineInput);
                if (localDepth <= maxDepth) continue;
                maxDepth = localDepth;
            }
        }
        return maxDepth;
    }

    private void updateBiblatex(IProject project, boolean biblatexMode, String biblatexBackend, boolean init) {
        if (!init) {
            boolean bibChanged;
            Boolean oldBLMode = (Boolean)TexlipseProperties.getSessionProperty((IResource)project, "biblatexMode");
            String oldBackend = (String)TexlipseProperties.getSessionProperty((IResource)project, "biblatexBackend");
            if (biblatexMode) {
                bibChanged = oldBLMode != null ? (biblatexBackend != null ? !biblatexBackend.equals(oldBackend) : oldBLMode == null) : true;
            } else {
                boolean bl = bibChanged = oldBLMode != null;
            }
            if (bibChanged) {
                TexlipseProperties.setSessionProperty((IResource)project, "rerunBibtex", new String("true"));
            }
        }
        if (biblatexMode) {
            TexlipseProperties.setSessionProperty((IResource)project, "biblatexMode", new Boolean(true));
        } else {
            TexlipseProperties.setSessionProperty((IResource)project, "biblatexMode", null);
        }
        TexlipseProperties.setSessionProperty((IResource)project, "biblatexBackend", biblatexBackend);
    }

    private void updateReferences(IProgressMonitor monitor) {
        this.updateLabels(this.parser.getLabels());
        this.updateCommands(this.parser.getCommands());
        IProject project = this.getCurrentProject();
        if (project == null) {
            return;
        }
        IFile cFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        boolean isMainFile = cFile.equals((Object)TexlipseProperties.getProjectSourceFile(project));
        this.pollCancel(monitor);
        if (this.parser.isLocalBib()) {
            TexlipseProperties.setSessionProperty((IResource)project, "biblatexLocalBib", new Boolean(true));
        } else {
            TexlipseProperties.setSessionProperty((IResource)project, "biblatexLocalBib", null);
        }
        if (isMainFile) {
            String oldStyle;
            String bibstyle;
            boolean biblatexMode = this.parser.isBiblatexMode();
            this.updateBiblatex(project, biblatexMode, this.parser.getBiblatexBackend(), false);
            String[] bibs = this.parser.getBibs();
            this.updateBibs(bibs, biblatexMode, (IResource)cFile);
            this.pollCancel(monitor);
            String preamble = this.parser.getPreamble();
            if (preamble != null) {
                TexlipseProperties.setSessionProperty((IResource)project, "preamble", preamble);
            }
            if (!(biblatexMode || (bibstyle = this.parser.getBibstyle()) == null || (oldStyle = (String)TexlipseProperties.getSessionProperty((IResource)project, "bibStyle")) != null && bibstyle.equals(oldStyle))) {
                TexlipseProperties.setSessionProperty((IResource)project, "bibStyle", bibstyle);
                TexlipseProperties.setSessionProperty((IResource)project, "bibFilesChanged", new Boolean(true));
            }
        }
    }

    private void updateBibs(String[] bibNames, boolean biblatexMode, IResource resource) {
        IProject project = this.getCurrentProject();
        if (project == null) {
            return;
        }
        if (!biblatexMode) {
            int i = 0;
            while (i < bibNames.length) {
                if (!bibNames[i].endsWith(".bib")) {
                    int n = i;
                    bibNames[n] = String.valueOf(bibNames[n]) + ".bib";
                }
                ++i;
            }
        }
        if (this.bibContainer.checkFreshness(bibNames)) {
            return;
        }
        TexlipseProperties.setSessionProperty((IResource)project, "bibFiles", bibNames);
        List<String> newBibs = this.bibContainer.updateBibHash(bibNames);
        IPath path = resource.getFullPath().removeFirstSegments(1).removeLastSegments(1);
        if (!path.isEmpty()) {
            path = path.addTrailingSeparator();
        }
        KpsewhichRunner filesearch = new KpsewhichRunner();
        for (String name : newBibs) {
            try {
                String filepath = "";
                IResource res = project.findMember(path + name);
                if (res == null) {
                    IContainer sourceDir = TexlipseProperties.getProjectSourceDir(project);
                    res = sourceDir.findMember(name);
                }
                if (res != null) {
                    filepath = res.getLocation().toOSString();
                }
                if (res == null) {
                    filepath = filesearch.getFile(resource, name, "bibtex");
                    if (filepath.length() > 0 && !new File(filepath).isAbsolute()) {
                        res = project.findMember(path + filepath);
                        filepath = res != null ? res.getLocation().toOSString() : "";
                    } else if (filepath.length() > 0) {
                        IFile f;
                        Path p = new Path(filepath);
                        if (name.indexOf(47) >= 0) {
                            name = name.substring(name.lastIndexOf(47) + 1);
                        }
                        if ((f = project.getFile(path + name)) != null && !f.exists()) {
                            f.createLink((IPath)p, 0, null);
                        }
                    }
                }
                if (filepath.length() > 0) {
                    BibParser parser = new BibParser(filepath);
                    try {
                        List bibEntriesList = parser.getEntries();
                        if (bibEntriesList != null && bibEntriesList.size() > 0) {
                            this.bibContainer.addRefSource(path + name, bibEntriesList);
                            continue;
                        }
                        if (bibEntriesList != null) continue;
                        MarkerHandler marker = MarkerHandler.getInstance();
                        marker.addFatalError((ITextEditor)this.editor, "The BibTeX file " + filepath + " contains fatal errors, parsing aborted.");
                    }
                    catch (IOException ioe) {
                        TexlipsePlugin.log("Can't read BibTeX file " + filepath, ioe);
                    }
                    continue;
                }
                MarkerHandler marker = MarkerHandler.getInstance();
                marker.addFatalError((ITextEditor)this.editor, "The BibTeX file " + name + " not found.");
            }
            catch (CoreException ce) {
                TexlipsePlugin.log("Can't run Kpathsea", ce);
            }
        }
        this.bibContainer.organize();
    }

    private void updateLabels(List<ReferenceEntry> labels) {
        IFile resource = this.getFile();
        if (resource == null) {
            return;
        }
        this.labelContainer.addRefSource(resource.getProjectRelativePath().toString(), labels);
        this.labelContainer.organize();
    }

    private void updateCommands(ArrayList<TexCommandEntry> commands) {
        IFile resource = this.getFile();
        if (resource == null) {
            return;
        }
        if (this.commandContainer.addRefSource(resource.getProjectRelativePath().toString(), commands)) {
            this.commandContainer.organize();
        }
    }

    private void processIncludes(List<OutlineNode> includes, IEditorInput input) {
        IProject project = this.getCurrentProject();
        if (project == null) {
            return;
        }
        IFile referFile = (IFile)input.getAdapter(IFile.class);
        if (referFile == null) {
            return;
        }
        for (OutlineNode node : includes) {
            IFile f = null;
            IFile mainTexFile = TexlipseProperties.getProjectSourceFile(project);
            if (mainTexFile != null) {
                f = TexProjectParser.findIFile(node.getName(), mainTexFile, project);
            }
            if (f == null) {
                f = TexProjectParser.findIFile(node.getName(), referFile, project);
            }
            if (f != null) continue;
            MarkerHandler marker = MarkerHandler.getInstance();
            String errorMsg = MessageFormat.format(TexlipsePlugin.getResourceString("parseErrorIncludeNotFound"), node.getName());
            marker.createErrorMarker((IResource)referFile, errorMsg, node.getBeginLine());
        }
    }

    private void createReferenceContainers() {
        boolean parseAll = false;
        IProject project = this.getCurrentProject();
        if (project == null) {
            if (this.bibContainer == null) {
                this.bibContainer = new ReferenceContainer();
            }
            if (this.labelContainer == null) {
                this.labelContainer = new ReferenceContainer();
            }
            if (this.commandContainer == null) {
                this.commandContainer = new TexCommandContainer();
            }
            return;
        }
        ReferenceContainer bibCon = (ReferenceContainer)TexlipseProperties.getSessionProperty((IResource)project, "bibContainer");
        if (bibCon == null) {
            this.bibContainer = new ReferenceContainer();
            TexlipseProperties.setSessionProperty((IResource)project, "bibContainer", this.bibContainer);
            parseAll = true;
        } else {
            this.bibContainer = bibCon;
        }
        ReferenceContainer labCon = (ReferenceContainer)TexlipseProperties.getSessionProperty((IResource)project, "labelContainer");
        if (labCon == null) {
            this.labelContainer = new ReferenceContainer();
            TexlipseProperties.setSessionProperty((IResource)project, "labelContainer", this.labelContainer);
            parseAll = true;
        } else {
            this.labelContainer = labCon;
        }
        TexCommandContainer comCon = (TexCommandContainer)TexlipseProperties.getSessionProperty((IResource)project, "commandContainer");
        if (comCon == null) {
            this.commandContainer = new TexCommandContainer();
            TexlipseProperties.setSessionProperty((IResource)project, "commandContainer", this.commandContainer);
            parseAll = true;
        } else {
            this.commandContainer = comCon;
        }
        if (parseAll) {
            this.createProjectDatastructs(project);
        }
    }

    private void createProjectDatastructs(IProject project) {
        IResource[] files = TexlipseProperties.getAllProjectFiles(project);
        if (files != null) {
            IFile mainFile = TexlipseProperties.getProjectSourceFile(project);
            int i = 0;
            while (i < files.length) {
                String ext = files[i].getFileExtension();
                if ("tex".equals(ext) || "ltx".equals(ext) || "sty".equals(ext)) {
                    try {
                        String input = TexlipseProperties.getFileContents(files[i]);
                        LatexRefExtractingParser lrep = new LatexRefExtractingParser();
                        lrep.parse(input);
                        if (lrep.isFatalErrors()) {
                            MarkerHandler marker = MarkerHandler.getInstance();
                            marker.addFatalError((ITextEditor)this.editor, "The file " + files[i].getFullPath() + " contains fatal errors, parsing aborted.");
                        } else {
                            ArrayList<TexCommandEntry> commands;
                            ArrayList<ReferenceEntry> labels = lrep.getLabels();
                            if (labels.size() > 0) {
                                this.labelContainer.addRefSource(files[i].getProjectRelativePath().toString(), labels);
                            }
                            if ((commands = lrep.getCommands()).size() > 0) {
                                this.commandContainer.addRefSource(files[i].getProjectRelativePath().toString(), commands);
                            }
                            if (files[i].equals((Object)mainFile)) {
                                String bibstyle;
                                String[] bibs = lrep.getBibs();
                                boolean biblatexMode = lrep.isBiblatexMode();
                                String biblatexBackend = lrep.getBiblatexBackend();
                                this.updateBiblatex(project, biblatexMode, biblatexBackend, true);
                                this.updateBibs(bibs, biblatexMode, files[i]);
                                String preamble = lrep.getPreamble();
                                if (preamble != null) {
                                    TexlipseProperties.setSessionProperty((IResource)project, "preamble", preamble);
                                }
                                if ((bibstyle = lrep.getBibstyle()) != null) {
                                    TexlipseProperties.setSessionProperty((IResource)project, "bibStyle", bibstyle);
                                }
                            }
                        }
                    }
                    catch (IOException ioe) {
                        TexlipsePlugin.log("Unable to open file " + files[i].getFullPath() + " for parsing", ioe);
                    }
                }
                ++i;
            }
            this.labelContainer.organize();
            this.commandContainer.organize();
        }
    }

    public IFile getFile() {
        if (this.editor.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.editor.getEditorInput()).getFile();
        }
        return null;
    }

    private IProject getCurrentProject() {
        return this.editor.getProject();
    }

    private synchronized void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private void pollCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void setStatusLineErrorMessage(String msg) {
        SubStatusLineManager slm = (SubStatusLineManager)this.editor.getEditorSite().getActionBars().getStatusLineManager();
        slm.setErrorMessage(msg);
        slm.setVisible(true);
    }

    public void removeStatusLineErrorMessage() {
        SubStatusLineManager slm = (SubStatusLineManager)this.editor.getEditorSite().getActionBars().getStatusLineManager();
        slm.setErrorMessage(null);
    }

    private class ParseJob
    extends Job {
        public ParseJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ArrayList rootNodes;
                if (TexDocumentModel.this.bibContainer == null) {
                    TexDocumentModel.this.createReferenceContainers();
                }
                TexDocumentModel.this.pollCancel(monitor);
                try {
                    rootNodes = TexDocumentModel.this.doParse(monitor);
                }
                catch (TexDocumentParseException texDocumentParseException) {
                    return Status.CANCEL_STATUS;
                }
                TexDocumentModel.this.pollCancel(monitor);
                TexDocumentModel.this.postParseJob.setRootNodes(rootNodes);
                TexDocumentModel.this.postParseJob.schedule();
                try {
                    TexDocumentModel.this.postParseJob.join();
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                IStatus result = TexDocumentModel.this.postParseJob.getResult();
                if (result != null && result.equals(Status.OK_STATUS)) {
                    try {
                        lock.acquire();
                        TexDocumentModel.this.pollCancel(monitor);
                        TexDocumentModel.this.setDirty(false);
                    }
                    finally {
                        lock.release();
                    }
                    return result;
                }
                return Status.CANCEL_STATUS;
            }
            catch (Exception exception) {
                return Status.CANCEL_STATUS;
            }
        }

        public boolean belongsTo(Object family) {
            return family.equals(TexDocumentModel.PARSER_FAMILY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostParseJob
    extends WorkbenchJob {
        private ArrayList<OutlineNode> rootNodes;
        private List<OutlineNode> fullOutlineNodes;

        public PostParseJob(String name) {
            super(name);
        }

        public void setRootNodes(ArrayList<OutlineNode> rootNodes) {
            this.rootNodes = rootNodes;
        }

        public void setFONodes(List<OutlineNode> rootNodes) {
            this.fullOutlineNodes = rootNodes;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                TexDocumentModel.this.updateDocumentPositions(this.rootNodes, monitor);
                TexDocumentModel.this.pollCancel(monitor);
                TexDocumentModel.this.editor.updateCodeFolder(this.rootNodes, monitor);
                TexDocumentModel.this.pollCancel(monitor);
                if (TexDocumentModel.this.editor.getOutlinePage() != null) {
                    TexDocumentModel.this.editor.getOutlinePage().update(TexDocumentModel.this.outlineInput);
                }
                if (this.fullOutlineNodes != null) {
                    TexDocumentModel.this.pollCancel(monitor);
                    if (TexDocumentModel.this.editor.getFullOutline() != null) {
                        TexDocumentModel.this.editor.getFullOutline().update(new TexOutlineInput(new ArrayList<OutlineNode>(this.fullOutlineNodes)));
                    }
                }
                return Status.OK_STATUS;
            }
            catch (Exception exception) {
                return Status.CANCEL_STATUS;
            }
        }
    }
}

