/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.texlipse.bibeditor.AbbrevManager;
import net.sourceforge.texlipse.bibeditor.BibDocumentModel;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.templates.BibTexTemplateCompletion;
import net.sourceforge.texlipse.templates.ProposalsComparator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class BibCompletionProcessor
implements IContentAssistProcessor {
    private BibTexTemplateCompletion templatesCompletion = new BibTexTemplateCompletion();
    private BibDocumentModel model;
    private AbbrevManager abbrManager;
    private ProposalsComparator proposalsComparator = new ProposalsComparator();

    public BibCompletionProcessor(BibDocumentModel model) {
        this.model = model;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int i;
        if (this.abbrManager == null) {
            this.abbrManager = this.model.getAbbrManager();
        }
        String completeDoc = viewer.getDocument().get();
        String latest = this.resolveLatestWord(completeDoc, offset);
        ICompletionProposal[] templates = this.computeTemplateCompletions(offset, latest.length(), latest, viewer);
        ICompletionProposal[] abbrevs = null;
        int completeStart = -1;
        int i2 = offset - 1;
        while (i2 > 0) {
            char c = completeDoc.charAt(i2);
            if (c == '=' || c == '#') {
                if (completeStart != -1) break;
                completeStart = i2 + 1;
                break;
            }
            if (Character.isWhitespace(c) && completeStart == -1) {
                completeStart = i2 + 1;
            } else if (c == '{' || c == '}' || c == '\"' || c == ',') {
                abbrevs = null;
            }
            --i2;
        }
        abbrevs = completeStart == -1 ? this.computeAbbrevCompletions(offset, 0, "") : this.computeAbbrevCompletions(offset, offset - completeStart, completeDoc.substring(completeStart, offset));
        int size = 0;
        if (abbrevs != null) {
            size += abbrevs.length;
        }
        if (templates != null) {
            size += templates.length;
        }
        if (size == 0) {
            return null;
        }
        int index = 0;
        ICompletionProposal[] value = new ICompletionProposal[size];
        if (abbrevs != null) {
            i = 0;
            while (i < abbrevs.length) {
                value[index] = abbrevs[i];
                ++index;
                ++i;
            }
        }
        if (templates != null) {
            i = 0;
            while (i < templates.length) {
                value[index] = templates[i];
                ++index;
                ++i;
            }
        }
        return value;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'=', '#'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ICompletionProposal[] computeAbbrevCompletions(int offset, int replacementLength, String prefix) {
        ReferenceEntry[] abbrevs = this.abbrManager.getCompletions(prefix);
        if (abbrevs == null) {
            return null;
        }
        ICompletionProposal[] result = new ICompletionProposal[abbrevs.length];
        int i = 0;
        while (i < abbrevs.length) {
            result[i] = new CompletionProposal(abbrevs[i].key, offset - replacementLength, replacementLength, abbrevs[i].key.length(), null, abbrevs[i].key, null, abbrevs[i].info);
            ++i;
        }
        return result;
    }

    public String resolveLatestWord(String doc, int offset) {
        int index = 1;
        while (offset - index >= 0) {
            if (Character.isWhitespace(doc.charAt(offset - index))) break;
            ++index;
        }
        if (--index > 0) {
            return doc.substring(offset - index, offset);
        }
        return "";
    }

    private ICompletionProposal[] computeTemplateCompletions(int offset, int replacementLength, String prefix, ITextViewer viewer) {
        ArrayList templateProposals = new ArrayList();
        this.templatesCompletion.addTemplateProposals(viewer, offset, templateProposals);
        ArrayList<ICompletionProposal> returnProposals = new ArrayList<ICompletionProposal>();
        for (ICompletionProposal proposal : templateProposals) {
            if (!proposal.getDisplayString().startsWith(prefix)) continue;
            returnProposals.add(proposal);
        }
        ICompletionProposal[] proposals = new ICompletionProposal[returnProposals.size()];
        returnProposals.toArray(proposals);
        Arrays.sort(proposals, this.proposalsComparator);
        return proposals;
    }
}

