/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.KpsewhichRunner;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.model.AbstractEntry;
import net.sourceforge.texlipse.model.TexCommandEntry;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class OpenDeclarationAction
implements IEditorActionDelegate {
    private IEditorPart targetEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    private void createStatusLineErrorMessage(String message) {
        if (this.targetEditor instanceof TexEditor) {
            TexEditor editor = (TexEditor)this.targetEditor;
            SubStatusLineManager slm = (SubStatusLineManager)this.targetEditor.getEditorSite().getActionBars().getStatusLineManager();
            slm.setErrorMessage(message);
            slm.setVisible(true);
            editor.getViewer().getTextWidget().getDisplay().beep();
        }
    }

    public void run(IAction action) {
        List<TexCommandEntry> entries;
        if (!(this.targetEditor instanceof TexEditor)) {
            throw new RuntimeException("Expecting text editor. Found: " + this.targetEditor.getClass().getName());
        }
        TexEditor editor = (TexEditor)this.targetEditor;
        IProject project = editor.getProject();
        if (project == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String docString = doc.get();
        IRegion comRegion = LatexParserUtils.getCommand(docString, selection.getOffset());
        if (comRegion == null) {
            this.createStatusLineErrorMessage(TexlipsePlugin.getResourceString("gotoDeclarationNoCommandFound"));
            return;
        }
        String command = docString.substring(comRegion.getOffset(), comRegion.getOffset() + comRegion.getLength());
        AbstractEntry refEntry = null;
        if (selection.getOffset() < comRegion.getOffset() + comRegion.getLength() && (entries = editor.getDocumentModel().getRefMana().getCompletionsCom(command.substring(1), 1)) != null && entries.size() > 0 && entries.get((int)0).fileName != null) {
            refEntry = entries.get(0);
        }
        if (refEntry == null && (command.indexOf("ref") >= 0 || command.indexOf("cite") >= 0 || command.equals("\\input") || command.equals("\\include")) || command.equals("\\bibliography")) {
            IRegion region = null;
            region = LatexParserUtils.getCommandArgument(docString, comRegion.getOffset());
            if (region == null) {
                this.createStatusLineErrorMessage(TexlipsePlugin.getResourceString("gotoDeclarationNoArgumentFound"));
                return;
            }
            String ref = docString.substring(region.getOffset(), region.getOffset() + region.getLength());
            if (command.indexOf("ref") >= 0) {
                refEntry = editor.getDocumentModel().getRefMana().getLabel(ref);
            } else if (command.indexOf("cite") >= 0) {
                if (ref.indexOf(44) > 0) {
                    int end;
                    int start;
                    int cIndex = selection.getOffset() - region.getOffset();
                    if (cIndex < 0) {
                        this.createStatusLineErrorMessage(TexlipsePlugin.getResourceString("gotoDeclarationNoArgumentFound"));
                        return;
                    }
                    if (ref.charAt(cIndex) == ',') {
                        --cIndex;
                    }
                    if ((start = ref.lastIndexOf(44, cIndex) + 1) < 0) {
                        start = 0;
                    }
                    if ((end = ref.indexOf(44, cIndex)) < 0) {
                        end = ref.length();
                    }
                    ref = ref.substring(start, end);
                }
                refEntry = editor.getDocumentModel().getRefMana().getBib(ref.trim());
            } else if (command.equals("\\include") || command.equals("\\input") || command.equals("\\bibliography")) {
                IFile refFile;
                IContainer dir;
                IResource file;
                if (command.equals("\\bibliography")) {
                    if (!ref.toLowerCase().endsWith(".bib")) {
                        ref = String.valueOf(ref) + ".bib";
                    }
                } else if (!ref.toLowerCase().endsWith(".tex")) {
                    ref = String.valueOf(ref) + ".tex";
                }
                if ((file = (dir = TexlipseProperties.getProjectSourceDir(project)).findMember(ref)) == null && (refFile = editor.getDocumentModel().getFile()) != null) {
                    dir = refFile.getParent();
                    file = dir.findMember(ref);
                }
                if (file == null) {
                    this.createStatusLineErrorMessage(MessageFormat.format(TexlipsePlugin.getResourceString("gotoDeclarationNoFileFound"), ref));
                    return;
                }
                try {
                    IDE.openEditor((IWorkbenchPage)editor.getEditorSite().getPage(), (IFile)((IFile)file.getAdapter(IFile.class)));
                }
                catch (PartInitException e) {
                    TexlipsePlugin.log("Open declaration:", e);
                }
                return;
            }
        }
        if (refEntry == null || refEntry.fileName == null) {
            this.createStatusLineErrorMessage(TexlipsePlugin.getResourceString("gotoDeclarationNoDeclarationFound"));
            return;
        }
        IFile file = project.getFile(refEntry.fileName);
        try {
            AbstractTextEditor part;
            if (!file.exists()) {
                KpsewhichRunner filesearch = new KpsewhichRunner();
                String filepath = filesearch.getFile((IResource)editor.getDocumentModel().getFile(), refEntry.fileName, "bibtex");
                if ("".equals(filepath)) {
                    this.createStatusLineErrorMessage(TexlipsePlugin.getResourceString("gotoDeclarationNoDeclarationFound"));
                    return;
                }
                File f = new File(filepath);
                part = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)editor.getEditorSite().getPage(), (URI)f.toURI(), (String)"net.sourceforge.texlipse.bibeditor.BibEditor", (boolean)true);
            } else {
                part = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)editor.getEditorSite().getPage(), (IFile)file);
            }
            IDocument doc2 = part.getDocumentProvider().getDocument((Object)part.getEditorInput());
            int lineOffset = doc2.getLineOffset(refEntry.startLine - 1);
            int offset = 0;
            if (command.indexOf("ref") >= 0 && refEntry.position != null) {
                offset = refEntry.position.offset;
            }
            part.getEditorSite().getSelectionProvider().setSelection((ISelection)new TextSelection(lineOffset + offset, 0));
        }
        catch (PartInitException e) {
            TexlipsePlugin.log("Jump2Label PartInitException", e);
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("Jump2Label BadLocationException", e);
        }
        catch (CoreException ce) {
            TexlipsePlugin.log("Can't run Kpathsea", ce);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.targetEditor instanceof TexEditor);
    }
}

