# This file belongs to the CEP package | Ten plik nale/zy do pakietu CEP
# This package is public domain        | Pakiet stanowi dobro powszechne
# For more info see `0CEP_LIC.ENG'     | Wi/ecej informacji w ,,0CEP_LIC.POL''
# ===========================================================================
# E: "COP filtered PS" --> "PS" converter
#      input - input file name
#      OUTF  - output file name
#      TMPSX - temporary PostScript file name
#
# P: Konwerter "COP filtered PS" --> "PS"
#      wej/scie - nazwa pliku konwertowanego
#      OUTF     - nazwa pliku wyj/sciowego
#      TMPSX    - nazwa tymczasowego pliku PostScriptowego

BEGIN {# preparing temporary files | przygotowywanie plik/ow tymczasowych
  ver_no=1.03
  gs_abort="2 2 .quit"
  if (TMPSX=="") TMPSX="tmp.psx"
  flag="was_begin"
}

 # check carefully whether the file to be processed was created by COP
 # sprawd/xmy staranne czy mamy do czynienie z plikiem stworzonym przez COP-a

/^%!PS-Adobe.* COP/ && flag~"was_begin" {flag="adobe"}
/^%%BoundingBox/    && flag~"was_adobe" {flag="bbox"}
/^%%Creator: COP/   && flag~"was_(adobe|bbox)" {flag="cops"}
/^currentfile.*cvx exec$/ && flag~"was_cops" {decodeline=$0; exit}
flag~"was" {exit}
{flag="was_" flag}

END {
   # error handling | obs/luga b/l/ed/ow
  if (decodeline=="") errmessage("not a COP file",1)
  printf "UNCOP ver. " ver_no ", decoding:"
  if (is_A85()) printf " A85"
  if (is_HEX()) printf " Hex"
  if (!is_HEX() && !is_A85()) printf " Bin"
  if (is_LZW()) printf ", LZW"
  if (is_RLE()) printf ", RLE"
  if (is_ZIP()) printf ", Flate"
  print ""
   # WRITE PostScript ENCODING PROGRAM | TWORZENIE PROGRAMU Postscript-owego
  out_ps_errorhandler()
   # skipping preamble | pomijanie preambu/ly
  out_ps("/b_string 4096 string def")
  out_ps("(" ps_fname(FILENAME) ") (r) file")
  for (i=1; i<=NR; ++i) out_ps("dup 255 string readline pop pop")
   # prepare decoding | przygotowywanie filtr/ow dekoduj/acych
  if (is_A85()) out_ps("/ASCII85Decode filter")
  if (is_HEX()) out_ps("/ASCIIHexDecode filter")
  if (is_LZW()) out_ps("/LZWDecode filter")
  if (is_RLE()) out_ps("/RunLengthDecode filter")
  if (is_ZIP()) out_ps("/FlateDecode filter")
  out_ps("(" ps_fname(OUTF) ") (w) file")
  out_ps("exch")
   # loop decoding the Postscript file | p/etla dekoduj/aca plik Postscriptowy
  out_ps("{dup b_string readstring")
  out_ps("not exch 3 index exch")
  out_ps("writestring {exit} if} loop")
  out_ps("closefile closefile quit")
  printf "."
}

function ps_fname(s) {gsub(/\\/,"/",s); return(s)}

function out_ps(s) {print s > TMPSX}

function out_ps_errorhandler() {
  out_ps("/errq {" gs_abort "} def")
  out_ps("errordict begin ")
  out_ps("/ioerror {(\\010!Input/Output error occurred. (Disk full?)\\n\\007)")
  out_ps("  print errq} def")
  out_ps("/handleerror {$error begin (Something went wrong) print")
  out_ps("  (\\n Error: ) print errorname 255 string cvs print")
  out_ps("  (\\n\\007) print end errq} def")
  out_ps("end")
   #
  out_ps("systemdict /resourcestatus known not")
  out_ps("{(\\010!This version of Ghostscript doesn't support required Level 2 features\\n\\007)")
  out_ps("  print quit} if")
  if (is_A85()) check_filter("ASCII85Decode", "ASCII85Decode filter")
  if (is_HEX()) check_filter("ASCIIHexDecode", "ASCIIHexDecode filter")
  if (is_LZW()) check_filter("LZWDecode", "LZWDecode filter")
  if (is_RLE()) check_filter("RunLengthDecode", "RunLengthDecode filter")
  if (is_ZIP()) check_filter("FlateDecode", "FlateDecode filter")
}
  function check_filter(name, expl) {
    out_ps("/" name " /Filter resourcestatus {pop pop}")
    out_ps("{(\\010!This version of Ghostscript doesn't support " expl "\\n\\007)")
    out_ps("  print errq} ifelse")
  }

function errmessage(errname, errnum) {
 print "UNCOP ERROR:", errname "\007"; exit(errnum)
}

 # determine file decoding method | ustalanie sposobu dekodowania pliku
function is_A85() {return (decodeline~/\/ASCII85Decode/)}
function is_HEX() {return (decodeline~/\/ASCIIHexDecode/)}
function is_LZW() {return (decodeline~/\/LZWDecode/)}
function is_RLE() {return (decodeline~/\/RunLengthDecode/)}
function is_ZIP() {return (decodeline~/\/FlateDecode/)}
