/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;

public class LocalInfilePacket
extends ResultPacket {
    private long fieldCount;
    private String fileName;

    public LocalInfilePacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        this.fieldCount = reader.getLengthEncodedBinary();
        if (this.fieldCount != -1L) {
            throw new AssertionError((Object)"field count must be -1");
        }
        this.fileName = reader.readString("UTF-8");
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return this.fileName;
    }

    @Override
    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.LOCALINFILE;
    }

    @Override
    public byte getPacketSeq() {
        return 0;
    }
}

