/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;

public class PDAnnotationTextMarkup
extends PDAnnotationMarkup {
    public static final String SUB_TYPE_HIGHLIGHT = "Highlight";
    public static final String SUB_TYPE_UNDERLINE = "Underline";
    public static final String SUB_TYPE_SQUIGGLY = "Squiggly";
    public static final String SUB_TYPE_STRIKEOUT = "StrikeOut";

    private PDAnnotationTextMarkup() {
    }

    public PDAnnotationTextMarkup(String subType) {
        this.setSubtype(subType);
        this.setQuadPoints(new float[0]);
    }

    public PDAnnotationTextMarkup(COSDictionary field) {
        super(field);
    }

    public void setQuadPoints(float[] quadPoints) {
        COSArray newQuadPoints = new COSArray();
        newQuadPoints.setFloatArray(quadPoints);
        this.getCOSObject().setItem(COSName.QUADPOINTS, (COSBase)newQuadPoints);
    }

    public float[] getQuadPoints() {
        COSArray quadPoints = (COSArray)this.getCOSObject().getDictionaryObject(COSName.QUADPOINTS);
        if (quadPoints != null) {
            return quadPoints.toFloatArray();
        }
        return null;
    }

    public void setSubtype(String subType) {
        this.getCOSObject().setName(COSName.SUBTYPE, subType);
    }

    @Override
    public String getSubtype() {
        return this.getCOSObject().getNameAsString(COSName.SUBTYPE);
    }
}

