/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : token.cc
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/

#define max( a, b )            ( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )
#define min( a, b )            ( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )

#include <strstream.h>
#include <string.h>            // strcmp; most unusual, temporarily
#include <stdlib.h>            // exit
#include <ctype.h>
#include "token.h"
#include "strlist.h"
#include "init.h"
#include "staff.h"
#include "mpp.h"

istream& char2istream( const char* s )
{
    static char* buf = 0;
    static istrstream* is = 0;

    if ( buf )
        delete buf;
    if ( is )
        delete is;

    String string( s );

    buf = new char[ string.len() + 1 ];

    string( buf );
    is = new istrstream( buf, string.len() );
    
    return *is;
}    

#ifndef __TOKENCOMPARE
#define __TOKENCOMPARE
int Token::compare( const Object& test1, void* test2 )
{
#ifdef __TOKENCHARPTR
                               // this is each time, very inefficient
                               // perhaps make Token::name a String!
#if 1
    String token( ( (const Token&)test1).name );
    ;// monitor << token << ":";
    return token.compare( (const char*)test2 );
#else
    const char* s1 = (const char*)( (const Token&)test1 ).name;
    const char* s2 = (const char*)test2;
    if ( *s1 && *s2 )
        {
        if ( s1[ 0 ] != s2[ 0 ] )
            return 0;
        else
            {
            if ( s1[ 1 ] != s2[ 1 ] )
                return 0;
            else               // we can't do +2 , since len may be 1 char
                return ( !strcmp( s1 + 1, s2 + 1 ) );
            }
        }
    else 
        return 0;
#endif
#else
    return ( (const Token&)test1 ).name.compare( (const char*)test2 );
#endif    
}
#endif

#if 0
/****************************************************************************
  class MusicToken
--*/

MusicToken::MusicToken( const char* s, const int p ) :
    Token( s, p )
{
}  

MusicToken::~MusicToken()
{
}

void MusicToken::calculate()
{
}
//-- class MusicToken //
#endif

/****************************************************************************
  class Token
--*/

#ifdef __TOKENCHARPTR
Token::Token( const char* s, const int p ) :
    name( s ),
    parameterCount( p )
{
}  
#else
Token::Token( const char* s, const int p ) :
    name( ),
    parameterCount( p )
{
    name = s;
}  
#endif

Token::~Token()
{
}

String Token::_getFrom( istream& is )
{
    ;// monitor << "Token::_getFrom" << endl;

    char c = is.peek();
    String& s = *new String;

    while ( validCharacter( c ) && ! is.eof() )
        {
        is.get( c );
        s += c;
        c = is.peek();
        }
        
    return s;
}

int Token::getFrom( Staff& staff )
{
    ;// monitor << "Token::getFrom" << endl;
    String s;
    s = Token::_getFrom( *staff.is );

    ;// monitor << "leaving Token::getFrom" << endl;
    return 0;
}

int Token::validCharacter( const char c ) const
{
    return ( c != char( EOF ) );
}
//-- class Token //

/****************************************************************************
  class WhiteSpace
--*/

WhiteSpace::WhiteSpace( Staff& staff ) :
    length( 0 ),
    Token( "" )
{
    getFrom( staff );
}

WhiteSpace::~WhiteSpace()
{
}

int WhiteSpace::getFrom( Staff& staff )
{
    istream& is = *staff.is;

    char c = is.peek();

//    while ( validCharacter( c ) )
    while ( ( c == ' ') || ( c == '\t' ) || ( c == '\n' ) )
        {
        is.get( c );
        length++;
        if ( c == '\n' )
            staff.line++;
        c = is.peek();    
        }
    if ( c == char( EOF ) )
        length = min( length, -1 );
       
    return 0;     
}

int WhiteSpace::validCharacter( const char c ) const
{
    return ( Token::validCharacter( c ) && ( isspace( c ) || ( c == '\n' ) ) );
}

//-- class WhiteSpace //
