/* Output from p2c, the Pascal-to-C translator */
/* From input file "tp_misc.pas" */

#ifdef __TURBOC__
#include <IO.h>
#endif
#include <stdio.h>
#include <string.h>

#define TP_MISC_G
#include "tp_misc.h"


/**********************************************/
unsigned int Power(TheNumber,TheExp)
unsigned int TheNumber;
unsigned int TheExp;
{
  /**********************************************/
  unsigned int tmp;

  tmp = 1;
  while (TheExp > 0) {
    tmp *= TheNumber;
    TheExp--;
  }
  return tmp;
}  /* power */

#ifdef Doemaar  /* komt ook voor in tp_debug.c */
/********************************************************/
void WriteDebugInfo(char *Instring)
{
  /********************************************************/
  if (!Debug)
    return;
  switch (DebugOut) {

  case SCREEN:
    puts(Instring);
    break;

  case DEBFILE:
    fprintf(DebugFile, "%s\n", Instring);
    break;

  case PRINT:
    cprintf("%s\n", Instring);
    break;
  }
}
#endif

/********************************************************/
Char *I2S(Result, Num)
Char *Result;
long Num;
{
  /********************************************************/
  Char Res[26];

  sprintf(Res, "%12ld", Num);
  strcpy(Result, Res);
  return Result;
}


/********************************************************/
Char *SI2S(Result, Num)
Char *Result;
long Num;
{
  /********************************************************/
  Char Res[26];

  sprintf(Res, "%12ld", Num);
  strcpy(Result, Res);
  return Result;
}


/********************************************************/
Char *B2S(Result, Num)
Char *Result;
long Num;
{
  /********************************************************/
  Char Res[26];

  sprintf(Res, "%ld", Num);
  strcpy(Result, Res);
  return Result;
}


/********************************************************/
Char *LI2S(Result, Num)
Char *Result;
long Num;
{
  /********************************************************/
  Char Res[26];

  sprintf(Res, "%12ld", Num);
  strcpy(Result, Res);
  return Result;
}


/********************************************************/
Char *W2S(Result, Num)
Char *Result;
long Num;
{
  /********************************************************/
  Char Res[26];

  sprintf(Res, "%12lu", Num);
  strcpy(Result, Res);
  return Result;
}


/********************************************************/
long TimeDiff(time2, time1)
MeasureTime time2, time1;
{
  /********************************************************/
  long dt;

  dt = (time2.Measure - time1.Measure) * PieceContr.TicksPerMeasure;
  dt += time2.MPart - time1.MPart;
  return dt;
}


/********************************************************/
boolean EqualTime(time2, time1)
MeasureTime time2, time1;
{
  /********************************************************/
  boolean Result;

  Result = true;
  if (time2.Measure != time1.Measure)
    Result = false;
  if (time2.MPart != time1.MPart)
    return false;
  return Result;
}


/*********************************************************************/
Void AddTime(time2, time1, time3)
MeasureTime time2, time1, *time3;
{
  /*********************************************************************/
  long M;

  M = PieceContr.TicksPerMeasure * (time1.Measure + time2.Measure) +
      time1.MPart + time2.MPart;
  time3->Measure = M / PieceContr.TicksPerMeasure;
  time3->MPart = M % PieceContr.TicksPerMeasure;
/* p2c: tp_misc.pas, line 124:
 * Note: Using % for possibly-negative arguments [317] */
}


/*********************************************************************/
void SetTim(time1,M,P)
MeasureTime *time1;
unsigned int M,P;
{
  /*********************************************************************/
  time1->Measure = M;
  time1->MPart = P;
}


/********************************************************/
/* Void DisplayLicense(ProgName)
char *ProgName;*/
void DisplayLicense()
{
  /********************************************************/
  FILE *f;
  /* long T; */
#ifdef __TURBOC__
  struct ftime T;
#endif
  /* DateTime DT;   defined in DOS unit */

  f = NULL;
  printf("********************************************************\n");
  printf("*        Midi2TeX translator %s           *\n",VERSION);
  printf("*      authors:  H.J.P. Kuykens, A.H. Verbruggen       *\n");
  printf("********************************************************\n");
  if (f != NULL)
    fclose(f);
}


/**************************************************/
boolean FileExists(Filename)
Char *Filename;
{
  /**************************************************/
  boolean Result;
  FILE *f;

  f = NULL;
  f=fopen(Filename,"r");
  Result = (f != NULL)&&(*Filename != '\0');
  if (f != NULL) {fclose(f);}
  f = NULL;
  return Result;
}  /* FileExists*/

unsigned int Probeer(getal)
unsigned int getal;
{ return getal;
}
void _TP_Misc_init()
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}
