/* Header for module TP_Decl, generated by p2c */

#ifndef TP_DECL_H
#define TP_DECL_H

#ifdef TP_DECL_G
# define vextern
#else
# define vextern extern
#endif

#include <stdio.h>
#undef FALSE
#undef TRUE

typedef int boolean;
#define FALSE (0)
#define TRUE (1)
typedef unsigned char uchar;

/* #define uchar 		unsigned char */
#define Char 		char
#define  Void 		void

#define NilStr          '\0'
#define BufSize_        512     /* 8192 */
#define NoTracks        16
#define MAXSLURR        10
#define true		TRUE
#define false		FALSE
    /* this is the maximum-1 that MusicTeX can handle */

#define MAXBEAMS        9   /* ditto */
#define MAXPARTS        25
#define PT              3.5   /* 0.1 mm  1 inch/72.27 = 25.4/72.27 mm */
#define VERSION   	"C-version V 1.2"

typedef enum {
  WH, WHPPP, WHPP, WHP, H, HPPP, HPP, HP, Q, QPPP, QPP, QP, CPPP,
  CPP, C3, CP, C, CCPP, CC3, CCP, CC, CCC3, CCCP, CCC, CCCC3, CCCCP, CCCC
  } NoteTypes;

typedef enum { SCREEN, DEBFILE, PRINT, NODEB } DebugType;

typedef enum {
   VOID, NOTEON, NOTEOFF, REST, TXT, SIGNATURE, PEDAL, KEYSIGN } EventType;

typedef enum { UP, DOWN } OrientType;

typedef enum { VIOLIN, ALTO1, ALTO2, ALTO3, ALTO4, ALTO5, BASS } ClefType;

typedef enum {  STARTSLUR, ENDSLUR, REPEATSLUR } SlurType;

typedef enum {  NON, FLAT, SHARP, CORRECT } KeySignType;

typedef struct {
  char p[81];
  char r[3];
  char d[81];
#ifdef THINK_C  
  char n[40];  /* for including the path in the filename */
#endif
#ifndef THINK_C  
  char n[9];
#endif
  char e[5];
  } FileNameType;

typedef char String20Type[21];
typedef char String255Type[256];


typedef uchar BufType[BufSize_];

typedef struct {
  unsigned short	BufSemaphore;
  /*LastAvBytePnt,*/
  unsigned short	LastNoBytesRead;
  char *		BufPoint;
  char *		ReadBuf;
  /* BufType 		*ReadBuf; */
  long 			BytesProcessed;
  long 			ReadIn;
  long			i;
  boolean 		LastBlockRead;
  boolean		NoMoreData;
  long 			FilePosition;
  } FileRecord;

typedef struct MeasureTime {
  long Measure, MPart;
  } MeasureTime;

typedef struct NoteRecord {
  uchar MidiChnl, NoteVal, Velocity;
  NoteTypes NoteType;
  EventType Event;
  OrientType Orient;
  long FilePos;
  MeasureTime EndTime, StartTime;
  boolean ChordNote, BeamNote, SlurrNote;
  struct NoteRecord *Next, *Prev;
  Char *MetaTxt;
  } NoteRecord;

typedef struct BeamRecord {
  NoteRecord 	*StartNote, *EndNote;
  uchar 	NoNotes, Pitch, Numb;
  char 		Slope;
  OrientType 	Orient;
  NoteTypes 	NoteType;
  boolean 	Chain2Next;
  } BeamRecord;

typedef struct SlurrRecord {
  NoteRecord	*NotePnt;
  uchar 	NoteVal, Numb1, Numb2;
  SlurType 	KindOf;
  OrientType	Orient;
  boolean 	Occupied;
  } SlurrRecord;

typedef struct ChordRecord {
  NoteRecord *StartNote, *EndNote;
  uchar NoNotes;
  boolean ChordFinished;
  } ChordRecord;

typedef struct AccKeyType {
  KeySignType c, d, e, f, g, a, b;
  } AccKeyType;

typedef AccKeyType AccKeyArray[NoTracks];

typedef struct HeapRecord {
  NoteRecord *Tail;
  unsigned short Size;
  } HeapRecord;

typedef NoteRecord NoteArrayType[50];
typedef ChordRecord ChordArrayType[25];
typedef BeamRecord BeamArrayType[MAXBEAMS];
typedef SlurrRecord SlurrArrayType[MAXSLURR];

typedef struct TrackRecord {
  HeapRecord NoteList, SpillList;
  ChordArrayType ChordArray;
  BeamArrayType BeamArray;
  SlurrArrayType SlurrArray;
  uchar ChStackEnd, ChStackPoint, NotesSounding, StatusByte;
  MeasureTime LastNoteOffTime, Curtime, OldTime, OldOldTime;
  FileRecord FilRec;
  long SlurrPt, BeamPt, ChordPt;
  boolean Beam, Slurring, Chord, Skip, Instrument, ForceZeroBeams,
	  EndOfTrackRead;
  ClefType Clef;
  NoteRecord *PartStart[MAXPARTS], *PartEnd[MAXPARTS];
  AccKeyType AccKey;
  } TrackRecord;

typedef struct ControlInfo {
  uchar 	Num;        /* numerator of time signature */
  uchar 	Den;        /* denominator of time signature */
  long 		Division;   /* ticks in a quarter note */
  long 		TicksPerMeasure;
  unsigned short PartTime;
  uchar		PartType, nparts;
  boolean	PartOverRule;
  long 		Tempo;      /* int microsecs per quart note */
  unsigned short Twindow;   /* TimeWindow */
  long 		KeySign, Minor;
} ControlInfo;

typedef char MsArray[MAXPARTS][512];

vextern Char TmpStr[41],STR1[256],STR2[256],STR3[256];
/* vextern MsArray *Ms; */
vextern  uchar NilPos, Drno, abyte;
vextern  long ntracks, ninstruments, nTracksInInstr, CurTrack, FileFormat,
	     SafetyCounter, OK_result;
vextern  FILE *MidiFile;
vextern  FILE *DebugFile, *TexFile;
vextern  uchar *DebBuf, *TexBuf;
/*  SearchRec FileInfo; */
vextern  FileNameType DebugFileName, MidiFileName, TeXFileName;
vextern  Char path[80];
vextern  Char fname[9];
vextern  Char dir[80];
vextern  Char ext[4];
vextern  long ReadIn, i;
vextern  boolean Quantizing, QuitTrack, DebugFileOpened, MidiFileOpened,
		TeXHeaderFinished, Debug,ChangedContext;
vextern  long QuantTime;
vextern  long NoOfBytes, ALongInt;
vextern  TrackRecord TrackArray[NoTracks];
vextern  boolean SlurrIndexes[26];
vextern  ControlInfo PieceContr;
vextern  MeasureTime TempTime, OldTime, CurTime;
vextern  Char MeasureStr[256];
vextern  DebugType DebugOut;
vextern  long MeasureCount;
/* vextern  Char Notes[129];
   vextern  uchar CPosition; */
vextern  FileRecord HlpFilRec;
vextern  void *OldExitProc;
vextern  NoteRecord *N;
vextern  HeapRecord NotePool;
vextern  uchar TrackOrder[NoTracks];
vextern  long BeamIndex, OrderIndex, NoOfSkips, NoOfPages, Indent, BarIndent,
	     ScoreWidth, ScoreHeight, ScoreSep, LineHeight, MeasureMaxCnt,
	     ElemSkip, MusicSize, CumLength, CumHeight;
vextern  boolean SizingChanged, BatchProcessing;
/*
vextern Notes : ARRAY[1..66] of string[3] =
	    ('?','?','?','?','?','?','?','?','?','?','?','?','!'+CHAR(39)+'A',
	    '!'+CHAR(39)+'B','!'+CHAR(39)+'C','!'+CHAR(39)+'D','!'+CHAR(39)+'E',
	    '!'+CHAR(39)+'F','!'+CHAR(39)+'G','A','B','C','D','E','F','G','H',
	    'I','J','K','L','M','N','a','b','c','d','e','f','g','h','i','j',
	    'k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
	    '?','?',
	    '?','?','?','?','?');
*/


#undef vextern

#ifdef TP_DECL_G
char Notes[66][4] =
	    {"?","?","?","?","?","?","?","?","?","?","?","?",
	    "!'A","!'B","!'C","!'D","!'E","!'F","!'G",
	    "A","B","C","D","E","F","G","H","I","J","K","L","M","N",
	    "a","b","c","d","e","f","g","h","i","j","k","l","m","n",
	    "o","p","q","r","s","t","u","v","w","x","y","z",
	    "?","?","?","?","?","?","?"};

const int CPosition=36;
#else
extern char Notes[66][4];
extern CPosition;
#endif

#endif /*TP_DECL_H  */

void _TP_Decl_init(void);
void ErrorExit(long);
void WriteDebugInfo(char*);

/* End. */

