#pragma once

#include <memory.h>
#include <stdarg.h>
#include <malloc.h>
#include <string.h>
#include "ltx2mathmlexceptions.h"

#ifndef ZeroMemory
#define ZeroMemory(p,n) memset( (p), 0, (n) )
#endif



struct BufferStruct {
	char *m_buf;
	size_t m_index, m_size;
};

struct Buffer {
	char *m_buf;
	size_t m_index, m_size;
    Buffer();
	~Buffer();
	void setlength( size_t len );
	void write( const char *s, size_t len );
	void write( const char *s );
	size_t  length();
	void append( Buffer &buf, bool transfer = false );
	char *data( size_t *len = NULL );
	void insertAt( size_t index, const char *s );
	void format( const char *fmt, ... );
	void releaseBuffer( BufferStruct &buf );
	void reset();
	char *release();
	void destroy();
private:
	void _write( size_t index, const char *s, size_t len );
};

