import ch.bfh.lpdg.InteractionHandler;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.ParseException;
import org.junit.jupiter.api.Test;

import java.security.InvalidParameterException;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.fail;

public class InteractionHandlerTest {
    @Test
    public void testValidPathSingleFile() {
        var handler1 = InteractionHandler.getInstance();
        var handler2 = InteractionHandler.getInstance();
        var handler3 = InteractionHandler.getInstance();
        try {
            handler1.handleOptions(new String[]{"--debug", "-p", "src/test/resources/LaTexFolder/file1.cls"});
            handler2.handleOptions(new String[]{"--debug", "-p", "src/test/resources/LaTexFolder/file2.tex"});
            handler3.handleOptions(new String[]{"--debug", "-p", "src/test/resources/LaTexFolder/file3.sty"});
        } catch (Exception e) {
            fail("This should have worked.");
        }
    }

    @Test
    public void testValidPathSingleInvalidFile() {
        var handler = InteractionHandler.getInstance();
        try {
            handler.handleOptions(new String[]{"--debug", "-p", "src/test/resources/test.txt"});
            fail("The file is not a LaTeX-File and this should have failed.");
        } catch (Exception e) {
            assertEquals(IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testValidPathMultipleFiles() throws ParseException {
        var handler = InteractionHandler.getInstance();
        handler.handleOptions(new String[]{"--debug", "-p", "src/test/resources/LaTexFolder/"});

        // Depending on thest order, there should be at least 3 scannable files.
        assertThat(handler.getFiles().size()).isGreaterThan(3);
    }

    @Test
    public void testInvalidPath() {
        var handler = InteractionHandler.getInstance();

        try {
            handler.handleOptions(new String[]{"--debug", "-p", "/TEST/INVALID"});
        } catch (Exception e) {
            assertEquals(InvalidParameterException.class, e.getClass());
            assertEquals(e.getMessage(), "The given path is invalid: /TEST/INVALID");
            return;
        }
        fail("The path is invalid and should have thrown an exception.");
    }

    @Test
    public void testNullPath() {
        var handler = InteractionHandler.getInstance();

        try {
            handler.handleOptions(new String[]{"--debug", "-p"});
            fail("The path is null and should have thrown an exception.");
        } catch (Exception e) {
            assertEquals(MissingArgumentException.class, e.getClass());
        }
    }

    @Test
    public void testEmptyPath() {
        var handler = InteractionHandler.getInstance();

        try {
            handler.handleOptions(new String[]{"--debug", "-p", ""});
            fail("The path is empty and should have thrown an exception.");
        } catch (Exception e) {
            assertEquals(MissingArgumentException.class, e.getClass());
        }
    }
}
