import ch.bfh.lpdg.DependencyScanner;
import ch.bfh.lpdg.GraphHelper;
import ch.bfh.lpdg.InteractionHandler;
import ch.bfh.lpdg.datastructure.DependencyType;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;

import static org.assertj.core.api.Assertions.assertThat;

class GraphHelperTest {

    final DependencyScanner dependencyScanner = DependencyScanner.getInstance();
    final GraphHelper graphHelper = new GraphHelper();

    @Test
    void findDependencies_checkDependencyName() throws IOException {
        String PATH = "src/test/resources/LaTexFolder/file1.cls";
        final File file = new File(PATH);

        var dependency = dependencyScanner.findDependencies(file.getAbsolutePath(), DependencyType.FILE, "", Collections.emptyList(), 5);

        String outputPath = "src/test/resources/LaTexFolder/";
        var dependenciesFilePath = this.graphHelper.createFileForDependency(dependency, outputPath);

        final var resultFile = new File(dependenciesFilePath.toString());

        final String dependenciesContent = new String(Files.readAllBytes(Paths.get(resultFile.toString())));
        final String graphContent = new String(Files.readAllBytes(Paths.get(outputPath + "dependencyGraph.dot")));

        assertThat(resultFile.getName()).isEqualTo("dependencies_file1.tex");

        // Check if dependencies file was created and contains correct dependency graph
        assertThat(dependenciesContent).contains("\\digraph{dependencyGraph}{");
        assertThat(dependenciesContent).contains("file1 -> xcolor;");
        assertThat(dependenciesContent).contains("file1 -> makecell;");

        // Check if graph file was created and contains correct dependencies
        assertThat(graphContent).contains("digraph dependencyGraph ");
        assertThat(graphContent).contains("file1 -> xcolor;");
        assertThat(graphContent).contains("file1 -> makecell;");
    }

    @Test
    void findDependencies_check_include_abstract() throws IOException {
        String PATH = "src/test/resources/LaTexFolder/file4.tex";
        String DIR_PATH = "/src/test/resources/LaTexFolder/";

        InteractionHandler instance = InteractionHandler.getInstance();
        instance.setPath(instance.getUserDirectory() + DIR_PATH);

        final File file = new File(PATH);

        var dependency = dependencyScanner.findDependencies(file.getAbsolutePath(), DependencyType.FILE, "", Collections.emptyList(), 5);

        String outputPath = "src/test/resources/LaTexFolder/";
        var dependenciesFilePath = this.graphHelper.createFileForDependency(dependency, outputPath);

        final var resultFile = new File(dependenciesFilePath.toString());

        final String dependenciesContent = new String(Files.readAllBytes(Paths.get(resultFile.toString())));
        final String graphContent = new String(Files.readAllBytes(Paths.get(outputPath + "dependencyGraph.dot")));

        assertThat(resultFile.getName()).isEqualTo("dependencies_file4.tex");

        // Check if dependencies file was created and contains correct dependency graph
        assertThat(dependenciesContent).contains("\\digraph{dependencyGraph}{");
        assertThat(dependenciesContent).contains("abstract -> makecell;");
        assertThat(dependenciesContent).contains("makecell -> array;");

        // Check if graph file was created and contains correct dependencies
        assertThat(graphContent).contains("digraph dependencyGraph ");
        assertThat(dependenciesContent).contains("abstract -> makecell;");
        assertThat(dependenciesContent).contains("makecell -> array;");
    }
}