/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.lpdg;

import ch.bfh.lpdg.InteractionHandler;
import ch.bfh.lpdg.datastructure.Dependency;
import ch.bfh.lpdg.datastructure.DependencyType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.FileSystemUtils;

public class LatexHelper {
    private final InteractionHandler interactionHandler = InteractionHandler.getInstance();
    private Path tempFile;
    private Path sourceFile;
    private Path tempFolder;
    private Dependency dependencies;

    public LatexHelper(File file, Dependency dependencies) throws IOException {
        this.dependencies = dependencies;
        this.tempFile = this.createTempFile(file, ".temp");
        this.sourceFile = file.toPath();
        this.tempFolder = this.createTempFolder(Paths.get(file.getParent(), new String[0]));
        this.interactionHandler.printDebugMessage("Temp-File has been created. " + this.tempFile);
    }

    private static String getFileExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(".");
        return lastDotIndex != -1 ? fileName.substring(lastDotIndex) : "";
    }

    public void findUnnecessaryDependencies(Boolean overwrite, Boolean minimize) throws IOException {
        this.interactionHandler.printDebugMessage("Finding unnecessary Dependencies.");
        ArrayList<Dependency> unnecessaryDependencies = new ArrayList<Dependency>();
        for (Dependency dep : this.dependencies.getDependencyList()) {
            if (dep.getType() != DependencyType.REQUIRE_PACKAGE && dep.getType() != DependencyType.USE_PACKAGE) continue;
            this.interactionHandler.printDebugMessage("Trying without " + dep.toString());
            this.replaceDependency(this.tempFile, dep.getSource(), "%" + dep.getSource());
            if (this.compileTempDocument(this.tempFolder.toAbsolutePath().toString(), this.tempFile.toAbsolutePath().toString())) {
                unnecessaryDependencies.add(dep);
                dep.IsUnused = true;
            }
            this.replaceDependency(this.tempFile, "%" + dep.getSource(), dep.getSource());
        }
        this.deleteTempFiles();
        if (unnecessaryDependencies.size() > 0) {
            System.out.println("\nThe following Packages are not needed:");
            for (Dependency dep : unnecessaryDependencies) {
                System.out.println("\t" + dep.getName());
            }
        }
        if (minimize.booleanValue() || overwrite.booleanValue()) {
            Path fileToMinimize = overwrite != false ? this.sourceFile : this.createTempFile(this.sourceFile.toFile(), ".minimized");
            this.writeMinimizedFile(fileToMinimize);
        }
    }

    public boolean compileTempDocument(String outputDirectory, String documentToCompile) {
        try {
            int readBytes;
            List<String> cmd = Arrays.asList("pdflatex", "-output-directory", outputDirectory, "-interaction", "nonstopmode", "-halt-on-error", "-file-line-error", documentToCompile);
            this.interactionHandler.printDebugMessage("Running: " + cmd);
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            InputStream is = process.getInputStream();
            byte[] buffer = new byte[1024];
            StringBuilder outputBuilder = new StringBuilder();
            while ((readBytes = is.read(buffer)) != -1) {
                String chunk = new String(buffer, 0, readBytes, StandardCharsets.UTF_8);
                outputBuilder.append(chunk);
            }
            this.interactionHandler.printDebugMessage(outputBuilder.toString());
            int res = process.waitFor();
            this.interactionHandler.printDebugMessage("ReturnCode: " + res);
            return res == 0;
        }
        catch (Exception e) {
            System.err.println("Error while compiling the temporary file: " + e);
            return false;
        }
    }

    private void writeMinimizedFile(Path minimizedFile) {
        for (Dependency dep : this.dependencies.getDependencyList()) {
            if (!dep.IsUnused) continue;
            this.replaceDependency(minimizedFile, dep.getSource(), "%" + dep.getSource());
        }
    }

    private void replaceDependency(Path file, String dependency, String replaceWith) {
        this.interactionHandler.printDebugMessage("Replacing " + dependency + " with " + replaceWith);
        try {
            String row;
            BufferedReader reader = Files.newBufferedReader(file);
            StringBuilder content = new StringBuilder();
            while ((row = reader.readLine()) != null) {
                content.append(row).append(System.lineSeparator());
            }
            String newContent = content.toString().replace(dependency, replaceWith);
            BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);
            writer.write(newContent);
            reader.close();
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Error in the temporary file: " + e);
        }
    }

    private Path createTempFile(File file, String identifier) throws IOException {
        String extension = LatexHelper.getFileExtension(file.getName());
        return Files.copy(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(file.getPath().replace(extension, identifier + extension), new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private Path createTempFolder(Path parentDirectory) throws IOException {
        return Files.createTempDirectory(parentDirectory, "LatexDependencyTemp", new FileAttribute[0]);
    }

    private void deleteTempFiles() throws IOException {
        FileSystemUtils.deleteRecursively(this.tempFolder.toFile());
        Files.delete(this.tempFile);
    }

    public LatexHelper() {
    }
}

