/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.File;
import java.util.List;

public class StringTool {
    public static String replace(String value, String from, String to) {
        return StringTool.replace(value, from, to, true);
    }

    public static String replace(String value, String from, String to, boolean aCaseSensitiveFlag) {
        if (value == null || value.length() == 0 || from == null || from.length() == 0) {
            return value;
        }
        if (to == null) {
            to = "";
        }
        if (!aCaseSensitiveFlag) {
            from = from.toLowerCase();
        }
        String result = value;
        int lastIndex = 0;
        int index = value.indexOf(from);
        if (index != -1) {
            StringBuffer buffer = new StringBuffer();
            while (index != -1) {
                buffer.append(value.substring(lastIndex, index)).append(to);
                lastIndex = index + from.length();
                index = value.indexOf(from, lastIndex);
            }
            buffer.append(value.substring(lastIndex));
            result = buffer.toString();
        }
        return result;
    }

    public static String escapeSpaces(String aPathString) {
        return StringTool.replaceOrEscapeAll(aPathString, null, null, true);
    }

    public static String replaceSpacesWithMinus(String aPathString) {
        return StringTool.replaceSpaces(aPathString, "-");
    }

    public static String replaceSpaces(String aPathString, String replaceWith) {
        return StringTool.replaceOrEscapeAll(aPathString, replaceWith, null, false);
    }

    public static String replaceOrEscapeAll(String aPathString, String replaceOrEscapeWith, String[] replaceWhat, boolean escape) {
        if (replaceWhat == null) {
            replaceWhat = new String[]{" ", "\t", "\n"};
        }
        if (replaceOrEscapeWith == null) {
            replaceOrEscapeWith = "\\";
        }
        for (String aReplaceWhat : replaceWhat) {
            aPathString = StringTool.replace(aPathString, aReplaceWhat, escape ? replaceOrEscapeWith + aReplaceWhat : replaceOrEscapeWith);
        }
        return aPathString;
    }

    public static String normalizePath(String destination, String fileSeparator) {
        String FILESEP = fileSeparator == null ? File.separator : fileSeparator;
        destination = StringTool.replace(destination, "\\", "/");
        destination = StringTool.replace(destination, "//", "/");
        destination = StringTool.replace(destination, ":", ";");
        destination = StringTool.replace(destination, ";", ":");
        destination = StringTool.replace(destination, "/", FILESEP);
        if ("\\".equals(FILESEP)) {
            destination = StringTool.replace(destination, ":", ";");
            destination = StringTool.replace(destination, ";\\", ":\\");
        }
        return destination;
    }

    public static String normalizePath(String destination) {
        return StringTool.normalizePath(destination, null);
    }

    public static String stringArrayToSpaceSeparatedString(String[] args) {
        String result = "";
        for (String arg : args) {
            result = result + arg + " ";
        }
        return result;
    }

    public static String getPlatformEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String UTF16() {
        return "UTF-16";
    }

    public static String listToString(List<?> aStringList) {
        return StringTool.listToString(aStringList, null);
    }

    public static String listToString(List<?> aStringList, String aLineSeparator) {
        String LineSeparator = aLineSeparator;
        if (LineSeparator == null) {
            LineSeparator = System.getProperty("line.separator", "\n");
        }
        StringBuffer temp = new StringBuffer();
        for (Object anAStringList : aStringList) {
            temp.append(anAStringList).append(LineSeparator);
        }
        return temp.toString();
    }

    public static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.toUpperCase().startsWith(prefix.toUpperCase());
    }
}

