/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.util.config.ConfigurableTask;
import java.util.logging.Logger;

public class ConfigurationActionTask {
    private static final Logger logger = Logger.getLogger(ConfigurationActionTask.class.getName());
    private String condition;
    private ConfigurableTask task;
    private RulesEngine rules;

    public ConfigurationActionTask(ConfigurableTask task, String condition, RulesEngine rules) {
        this.task = task;
        this.condition = condition;
        this.rules = rules;
    }

    public ConfigurableTask getConfigurableTask() {
        return this.task;
    }

    public void setConfigurableTask(ConfigurableTask task) {
        this.task = task;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void execute() throws Exception {
        if (this.condition == null || this.condition.trim().length() == 0 || this.rules.isConditionTrue(this.condition)) {
            logger.fine("Executing configuration task class " + this.task.getClass().getName());
            this.task.execute();
        } else {
            logger.fine("Condition " + this.condition + " not met - skipping configuration task class " + this.task.getClass().getName());
        }
    }
}

