{$N-,W-,G+}
Unit wbibbtns;

interface

uses WinTypes, WinProcs, Strings, rc_id, rc_bits;

const
  bbn_MouseMoved   = wm_User+1;
  bb_SetBitmap     = wm_User+1;
  bb_GetButtonInfo = wm_User+2;

  bbinf_EnabledBitmap  = 1;
  bbinf_DisabledBitmap = 2;

  bdBorderWidth = 1;
  bdShadowWidth = 1;

{ ==============================================================
  Bitmaped button custom control.
  ============================================================== }

function BitButtonWinFn(HWindow: HWnd; TheMessage: Word; wParam: Word;
                        lParam: Longint): Longint;

implementation

const

  TBarBtnClassName: PChar = 'BibDBTbarButton';

	idButtonStyle	  =	100;
	idCaption	      =	100;
	idControlId	    =	101;
	idTabStop	      =	102;
	idDisabled      =	103;
	idGroup         =	104;
	idDefaultButton	=	105;
	idPushButton	  =	106;
{	btDisableBits   = 100;}
	btDefBits       =	101;
	btUndefBits	    =	102;
	crDefCurs	      =	100;
	crUndefCurs	    =	101;

  ofState       = 2;
  ofBitmap      = 6;
  ofDisabled    = 8;
  ofSize        = 10; { Amount of window extra bytes to use }

  bsDisabled    = $0001;
  bsFocus       = $0002;
  bsKeyDown     = $0004;
  bsMouseDown   = $0008;
  bsMouseUpDown = $0010;
  bsDefault     = $0020;

  wmChar_KeyWasDown    = $40000000;
  wmChar_BeingReleased = $80000000;


{ BitButtonWinFn -----------------------------------------------
    Button window procedure.
  -------------------------------------------------------------- }
function BitButtonWinFn(HWindow: HWnd; TheMessage: Word; wParam: Word;
  lParam: Longint): Longint;
var
  DC: HDC;
  BitsNumber: Integer;
  Bitmap: TBitmap;
  Rect: TRect;
  Pt: TPoint;
  PS: TPaintStruct;
  l: longint;

{ Get ----------------------------------------------------------
    Get a window instance word.
  -------------------------------------------------------------- }
function Get(Ofs: Integer): Word;
begin
  Get := GetWindowWord(HWindow, Ofs);
end;

{ SetWord ------------------------------------------------------
    Set the value of a window instance word.
  -------------------------------------------------------------- }
procedure SetWord(Ofs: Integer; Val: Word);
begin
  SetWindowWord(HWindow, Ofs, Val);
end;

{ State --------------------------------------------------------
    Get the button's state word.
  -------------------------------------------------------------- }
function State: Word;
begin
  State := Get(ofState);
end;

{ TheBits -----------------------------------------------------
    Get the bitmap of the button.
  -------------------------------------------------------------- }
function EnabledBits: Word;
begin
  EnabledBits := Get(ofBitmap);
end;

function DisabledBits: Word;
begin
  DisabledBits := Get(ofDisabled);
end;

{ GetState -----------------------------------------------------
    Get the value of a state bit.
  -------------------------------------------------------------- }
function GetState(AState: Word): Boolean;
begin
  GetState := (State and AState) = AState;
end;

{ Paint --------------------------------------------------------
    Paint the button.  Called in responce to a WM_PAINT message
    and whenever the button changes state (called by Repaint).
  -------------------------------------------------------------- }
procedure Paint(DC: HDC);
const
  coGray = $00C0C0C0;
var
  MemDC: HDC;
  Bits, Oldbitmap: HBitmap;
  BorderBrush, OldBrush: HBrush;
  LogBrush: TLogBrush;
  Frame: TRect;
  Height, Width, XShift, YShift: Integer;
  Pressed,DisabledBitmapExists: boolean;
begin
  if not GetState(bsDisabled) then
  begin
    Bits:=DisabledBits;
    if Bits=0 then
    begin
      Bits:=EnabledBits;
      DisabledBitmapExists:=false;
    end else DisabledBitmapExists:=true;
  end else Bits:=EnabledBits;
  if (State and (bsMouseDown + bsKeyDown) <> 0) and
      not GetState(bsMouseUpDown) then
  begin
    Pressed:=true;
    XShift:=1; YShift:=1;
  end else
  begin
    Pressed:=false;
    XShift:=0; YSHift:=0;
  end;

  { Draw border }
  GetClientRect(HWindow, Frame);
  Height := Frame.bottom - Frame.top;
  Width := Frame.right - Frame.left;

  BorderBrush := GetStockObject(Black_Brush);
  OldBrush := SelectObject(DC, BorderBrush);
  PatBlt(DC, Frame.left+1, Frame.top, Width-2, bdBorderWidth, PatCopy);
  PatBlt(DC, Frame.left, Frame.top+1, bdBorderWidth, Height-2, PatCopy);
  PatBlt(DC, Frame.left+1, Frame.bottom - bdBorderWidth, Width-2,
    bdBorderWidth, PatCopy);
  PatBlt(DC, Frame.right - bdBorderWidth, Frame.top+1, bdBorderWidth,
    Height-2, PatCopy);

  if Pressed then
  begin
    SelectObject(DC, GetStockObject(DkGray_Brush));
    PatBlt(DC, Frame.left+bdBorderWidth, Frame.top+bdBorderWidth,
           Width-2*bdBorderWidth,1, PatCopy);
    PatBlt(DC, Frame.left+bdBorderWidth, Frame.top+bdBorderWidth,
           1, Height-2*bdBorderWidth, PatCopy);
  end else
  begin
    SelectObject(DC, GetStockObject(white_Brush));
    PatBlt(DC, Frame.left+bdBorderWidth, Frame.top+bdBorderWidth,
           Width-2*bdBorderWidth-1,1, PatCopy);
    PatBlt(DC, Frame.left+bdBorderWidth, Frame.top+bdBorderWidth,
           1, Height-2*bdBorderWidth-1, PatCopy);
    SelectObject(DC, GetStockObject(DkGray_Brush));
    PatBlt(DC, Frame.left+bdBorderWidth, Frame.bottom-bdBorderWidth,
           Width-2*bdBorderWidth,1, PatCopy);
    PatBlt(DC, Frame.right-bdBorderWidth, Frame.top+bdBorderWidth,
           1, Height-2*bdBorderWidth, PatCopy);
    PatBlt(DC, Frame.left+bdBorderWidth+1, Frame.bottom-bdBorderWidth-1,
           Width-2*bdBorderWidth-2,1, PatCopy);
    PatBlt(DC, Frame.right-bdBorderWidth-1, Frame.top+bdBorderWidth+1,
           1, Height-2*bdBorderWidth-2, PatCopy);
  end;

  SelectObject(DC, OldBrush);

  if Bits=0 then  { Blank bitmap }
  begin
    SelectObject(DC, GetStockObject(LtGray_Brush));
    PatBlt(DC,bdBorderWidth+1+XShift, bdBorderWidth+1+YShift,
           Width-2*bdBorderWidth-3, Height-2*bdBorderWidth-3, PatCopy);
    SelectObject(DC, OldBrush);
  end else                       { Draw bitmap }
  begin
    SelectObject(DC, OldBrush);
    MemDC := CreateCompatibleDC(DC);

    OldBitmap := SelectObject(MemDC, Bits);
    GetObject(Bits, Sizeof(Bitmap), @Bitmap);

    if not (GetState(bsDisabled) or DisabledBitmapExists) then
    begin
      { Gray out the button }
      OldBrush := SelectObject(DC, CreateSolidBrush(coGray));
      PatBlt(DC, bdBorderWidth, bdBorderWidth, Bitmap.bmWidth,
        Bitmap.bmHeight, PatCopy);
      DeleteObject(SelectObject(DC, OldBrush));

      { Draw the bitmap through a checked brush }
      LogBrush.lbStyle := bs_Pattern;
      LogBrush.lbHatch := LoadBitmap(HInstance, MakeIntResource(rc_btDisableBits));
      OldBrush := SelectObject(DC, CreateBrushIndirect(LogBrush));
      BitBlt(DC, bdBorderWidth, bdBorderWidth, Bitmap.bmWidth,
        Bitmap.bmHeight, MemDC, 0, 0, $00A803A9 {DPSoa});
      DeleteObject(SelectObject(DC, OldBrush));
      DeleteObject(LogBrush.lbHatch);
    end else
      BitBlt(DC, bdBorderWidth+1+XShift, bdBorderWidth+1+YShift, Bitmap.bmWidth,
             Bitmap.bmHeight, MemDC, 0, 0, srcCopy);

    SelectObject(MemDC, OldBitmap);
    DeleteDC(MemDC);
  end;
end;

{ Repaint ------------------------------------------------------
    Repaint the button. Called whenever the button changes
    state.
  -------------------------------------------------------------- }
procedure Repaint;
var
  DC: HDC;
begin
  DC := GetDC(HWindow);
  Paint(DC);
  ReleaseDC(HWindow, DC);
end;

{ SetState -----------------------------------------------------
    Sets the value of a state bit.  If the word changes value
    the button is repainted.
  -------------------------------------------------------------- }
procedure SetState(AState: Word; Enable: Boolean);
var
  OldState, NewState: Word;
begin
  OldState := State;
  if Enable then NewState := OldState or AState
  else NewState := OldState and not AState;
  if NewState <> OldState then
  begin
    SetWord(ofState, NewState);
    Repaint;
  end;
end;

{ InMe ---------------------------------------------------------
    Returns true if the given point is in within the border of
    the button.
  -------------------------------------------------------------- }
function InMe(lPoint: Longint): Boolean;
var
  R: TRect;
  Point: TPoint absolute lPoint;
begin
  GetClientRect(HWindow, R);
  InflateRect(R, -bdBorderWidth, -bdBorderWidth);
  InMe := PtInRect(R, Point);
end;

{ ButtonPressed ------------------------------------------------
    Called when the button is pressed by either the keyboard or
    by the mouse.
  -------------------------------------------------------------- }
procedure ButtonPressed;
begin
  SetState(bsMouseDown + bsMouseUpDown + bsKeyDown, False);
  SendMessage(GetParent(HWindow), wm_Command, GetDlgCtrlID(HWindow),
            	Longint(HWindow));
end;


{ LoadBits -----------------------------------------------------
    Load the bitmap for the button or the "NO BITMAP" version
    if it does not exist.
  -------------------------------------------------------------- }
procedure LoadBits(Wrd: Word; MapNumber: Word);
var
  MapBits: HBitmap;
begin
  MapBits := LoadBitmap(HInstance, pChar(MapNumber));
  SetWord(Wrd, MapBits);
end;

procedure SetBitmap(idEnabled,idDisabled: Word);
var
  MapBits: HBitmap;
begin
  MapBits := Get(ofBitmap);
  if MapBits<>0 then DeleteObject(MapBits);
  MapBits:=0; 
  if idEnabled<>0 then MapBits := LoadBitmap(HInstance, pChar(idEnabled));
  SetWord(ofBitmap,MapBits);
  MapBits := Get(ofDisabled);
  if MapBits<>0 then DeleteObject(MapBits);
  MapBits:=0; 
  if idDisabled<>0 then MapBits := LoadBitmap(HInstance, pChar(idDisabled));
  SetWord(ofDisabled,MapBits);
end;

begin
  BitButtonWinFn := 0;
  case TheMessage of
    {
    wm_KeyUp,wm_KeyDown:
      if ((wParam=vk_Control) or (wParam=vk_Shift)) and
       ((lParam and wmChar_KeyWasDown=0) =
        (lParam and wmChar_BeingReleased=0)) then
          PostMessage(GetParent(HWindow),TheMessage,wParam,lParam);
      begin
        GetWindowRect(HWindow,Rect);
        GetCursorPos(pt);
        messagebeep(0);
        message(num2str(pt.x)+','+num2str(pt.y)+','+num2str(Rect.left)+','
                +num2str(Rect.right)+','+num2str(Rect.Top)+','+num2str(Rect.Bottom)); 
        if PtInRect(Rect,pt) then
        begin
          messagebeep(0);
        end else
          BitButtonWinFn := DefWindowProc(HWindow, TheMessage, wParam, lParam);
      end;          }
    wm_Create:
      begin

        SetWord(ofBitmap, 0); SetWord(ofDisabled, 0);
	      GetWindowRect(HWindow, Rect);
	      Pt.X := Rect.Left;
	      Pt.Y := Rect.Top;
	      ScreenToClient(PCreateStruct (lParam)^.hwndParent, Pt);

	      { Intialize button state }
	      with PCreateStruct(lParam)^ do
	      begin
	        if style and $1F = bs_DefPushButton then
	     	    SetState(bsDefault, True)
          else
            SetState(bsDefault, False);
	        if style and ws_Disabled = 0 then
		        SetState(bsDisabled, True)
          else
		        SetState(bsDisabled, False);
     	  end;
	    end;
    wm_NCDestroy:
      begin
	{ Destroy all saved bitmaps before the button is destroyed }
	      BitButtonWinFn := DefWindowProc(HWindow, TheMessage, wParam, lParam);
        if EnabledBits<>0  then DeleteObject(EnabledBits);
        if DisabledBits<>0 then DeleteObject(DisabledBits);
      end;
    bb_SetBitmap:
      begin
        SetBitmap(LoWord(lparam),HiWord(lParam));
	      GetObject(EnabledBits, SizeOf(Bitmap), @Bitmap);
	      MoveWindow(HWindow, 0, 0,
	        Bitmap.bmWidth + bdBorderWidth * 2+2,
	        Bitmap.bmHeight + bdBorderWidth * 2+2, False);

      end;
    bb_GetButtonInfo:
      case wParam of
        bbinf_EnabledBitmap:
          BitButtonWinFn := Longint(EnabledBits);
        bbinf_DisabledBitmap:
          BitButtonWinFn := Longint(DisabledBits);
      end;
    wm_Paint:
      begin
      	BeginPaint(HWindow, PS);
	      Paint(PS.hDC);
	      EndPaint(HWindow, PS);
      end;
    wm_EraseBkGnd:
      begin
	{ Squelch the painting of the background to eliminate flicker }
      end;
    wm_Enable:
      SetState(bsDisabled, wParam <> 0);
      {
    wm_SetFocus:
      SetState(bsFocus, True);
    wm_KillFocus:
      SetState(bsFocus or bsKeyDown or bsMouseDown or bsMouseUpDown, False);
    wm_KeyDown:
      if (wParam = $20) and not GetState(bsKeyDown) and
	         not GetState(bsMouseDown) then
	                 SetState(bsKeyDown, True);
    wm_KeyUp:
      if (wParam = $20) and GetState(bsKeyDown) then
        ButtonPressed;
      }
    wm_LButtonDblClk, wm_LButtonDown:
      if InMe(lParam) and not GetState(bsKeyDown) then
      begin
	      if GetFocus <> HWindow then SetFocus(HWindow);
	      SetState(bsMouseDown, True);
	      SetCapture(HWindow);
      end;
    wm_MouseMove:
      begin
        if GetState(bsMouseDown) then
	          SetState(bsMouseUpDown, not InMe(lParam))
        else
          SendMessage(GetParent(HWindow), bbn_MouseMoved, GetDlgCtrlID(HWindow),
          	0);
      end;
    wm_LButtonUp:
      if GetState(bsMouseDown) then
      begin
	      ReleaseCapture;
	      if not GetState(bsMouseUpDown) then ButtonPressed
	      else SetState(bsMouseDown + bsMouseUpDown, False);
      end;

    { *** Handling the rest of these messages are what, at least for
          the dialog manager, makes a push button a push button.  ***}
    wm_GetDlgCode:
      { Sent by the dialog manager to determine the control kind of
	a child window.  Returning dlgc_DefPushButton or
	dlgc_UndefPushButton causes the dialog manager to treat the
	control like a button, sending the bm_SetStyle message to
	move the default button style to the currenly focused button.

        The dlgc_Button constant is not documented by Microsoft
        (however, it is documented for OS/2 PM, and appears to work
        the same). If this constant is or'd in, the windows dialog
        manager will take care of all accelerator key processing,
        sending bm_SetState and bm_SetStyle messages when an
        acclerator key is pressed. There is a side effect to using
        the message, however, the dialog manager messes with the word
        at offset 0 from the user Window words. }

      if GetState(bsDefault) then
	           BitButtonWinFn:= dlgc_DefPushButton or dlgc_Button
      else
	           BitButtonWinFn := dlgc_UndefPushButton or dlgc_Button;
    bm_GetState:
      BitButtonWinFn := Integer(GetState(bsKeyDown));
    bm_SetState:
      SetState(bsKeyDown, wParam <> 0);
    bm_SetStyle:
      { Sent by the dialog manager when the button receives or looses
	focus and is not the default button, or when another button
	receives the focus and this button is the default button. }
      SetState(bsDefault, wParam = bs_DefPushButton);
  else
    BitButtonWinFn := DefWindowProc(HWindow, TheMessage, wParam, lParam);
  end;
end;

var
  Class: TWndClass;
  OldExitProc: Pointer;

procedure TBarExitProc; far;
begin
  ExitProc:=OldExitProc;
  UnregisterClass(TBarBtnClassName,HInstance);
end;

begin
  with Class do
  begin
    lpszClassName := TBarBtnClassName;
    hCursor       := LoadCursor(0, idc_Arrow);
    lpszMenuName  := nil;
    style         := cs_HRedraw or cs_VRedraw or cs_DblClks or cs_GlobalClass;
    lpfnWndProc   := TFarProc(@BitButtonWinFn);
    hInstance     := System.hInstance;
    hIcon         := 0;
    cbWndExtra    := ofSize;
    cbClsExtra    := 0;
    hbrBackground := 0;
  end;
  RegisterClass(Class);
  OldExitProc:=ExitProc;
  ExitProc:=@TBarExitProc;
end.
