{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

Unit bibcol64;

Interface

Uses
  WObjects,bibstrg,strings,wbibdisp;

Type
  PStrTypeObj = ^TStrTypeObj;
  TStrTypeObj = object(TObject)
    SOrig: PChar;
    constructor Init(S: string);
    destructor done; virtual;
  end;

  PBigColOne = ^TBigColOne;
  TBigColOne = object(TSortedCollection)
    CaseSen,Display: boolean;
    Ignore: array[0..255] of char;
    constructor Init(ALimit, ADelta: Integer; ACaseSen: boolean);
    function Compare(Key1, Key2: Pointer): Integer; virtual;
  end;

  PBigCol=^TBigCol;
  TBigCol=object(TObject)         
    ColCol: array[boolean] of TCollection;
    constructor init;
    destructor  done; virtual;
    procedure   AddString(S: string);
    function    FindStr(S: string; CaseSen: boolean; Ignor: string): string;
  end;


Implementation

{ TStrTypeObj methods }

constructor TStrTypeObj.Init(S: string);
var
  P: array[0..255] of char;
begin
  TObject.init;
  SOrig:=Nil;
  if S<>'' then
  begin
    StrPCopy(P,S);
    SOrig:=StrNew(P);
  end;
end;            { TStrTypeObj.Init }

destructor  TStrTypeObj.done; 
begin
  if SOrig<>Nil then StrDispose(SOrig); SOrig:=Nil;
  TObject.Done;
end;            { STtrTypeObj.Done }

{ TBigColOne methods }
constructor TBigColOne.Init(ALimit, ADelta: Integer; ACaseSen: boolean);
begin
  TSortedCollection.Init(ALimit,ADelta);
  CaseSen:=ACaseSen;
  Display:=false;
  Ignore[0]:=#0;
end;

function TBigColOne.Compare(Key1, Key2: Pointer): Integer;
var
  P1,P2: PStrTypeObj;
  IsEquiv: integer;
begin
  P1:=PStrTypeObj(Key1); P2:=PStrTypeObj(Key2);
  {
  if Display then
    message('"'+StrPas(P1^.SOrig)+'", "'+StrPas(P2^.SOrig)+'"');
  }
  IsEquiv:=0;
  if CaseSen then IsEquiv:=StrComp(P1^.SOrig,P2^.SOrig)
  else IsEquiv:=StrIComp(P1^.SOrig,P2^.SOrig);
  if (IsEquiv=0) and (StrComp(P2^.SOrig,Ignore)=0) then Compare:=-1
  else Compare:=IsEquiv;
end;

{ TBigCol methods }

constructor TBigCol.init;
begin
  TObject.init;
  ColCol[true].Init(8,8); ColCol[false].Init(8,8);
  ColCol[true].Insert(New(PBigColOne,init(512,512,true)));
  ColCol[false].Insert(New(PBigColOne,init(512,512,false)));
end;

destructor  TBigCol.done;
begin
  ColCol[true].FreeAll; ColCol[true].Done;
  ColCol[false].FreeAll; ColCol[false].Done;
  TObject.Done;
end;

procedure   TBigCol.AddString(S: string);
begin
  { First, see if it already there }
  {message('Add "'+S+'"');}
  if FindStr(S,true,'')<>'' then Exit;
  { If current collection is full, start another one }
  if PBigColOne(ColCol[true].at(ColCol[true].Count-1))^.Count>=MaxCollectionSize then
  begin
    ColCol[true].Insert(New(PBigColOne,init(512,512,true)));
    ColCol[false].Insert(New(PBigColOne,init(512,512,false)));
  end;
  PBigColOne(ColCol[true].at(ColCol[true].Count-1))^.Insert(New(PStrTypeObj,Init(S)));
  PBigColOne(ColCol[false].at(ColCol[false].Count-1))^.Insert(New(PStrTypeObj,Init(S)));
end;

function    TBigCol.FindStr(S: string; CaseSen: boolean; Ignor: string): string;
var
  i,Index: integer;
  P: PStrTypeObj;
  Found: boolean;
begin
  FindStr:='';
  i:=0; Found:=false;
  New(P,Init(S));
  while (i<ColCol[CaseSen].Count) and not Found do
  begin
    with PBigColOne(ColCol[CaseSen].at(i))^ do
    begin
      Display:=true;
      if Ignor='' then Ignore[0]:=#0
      else StrPCopy(Ignore,Ignor);
      if Search(P,Index) then
      begin
        FindStr:=StrPas(PStrTypeObj(at(Index))^.SOrig);
        Found:=true;
      end;
      Ignore[0]:=#0;
      Display:=false;
    end;
    inc(i);
  end;
  Dispose(P,Done);
end;                           { TBigCol.FindStr }







end.