/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.files;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.AraraIOException;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.rules.Directives;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/islandoftex/arara/core/files/ProjectFile;", "Lorg/islandoftex/arara/api/files/ProjectFile;", "path", "Lorg/islandoftex/arara/api/files/MPPPath;", "fileType", "Lorg/islandoftex/arara/api/files/FileType;", "priority", "", "<init>", "(Lorg/islandoftex/arara/api/files/MPPPath;Lorg/islandoftex/arara/api/files/FileType;I)V", "getPath", "()Lorg/islandoftex/arara/api/files/MPPPath;", "getFileType", "()Lorg/islandoftex/arara/api/files/FileType;", "getPriority", "()I", "equals", "", "other", "", "hashCode", "fetchDirectives", "", "Lorg/islandoftex/arara/api/rules/Directive;", "parseOnlyHeader", "toString", "", "Companion", "core"})
public class ProjectFile
implements org.islandoftex.arara.api.files.ProjectFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MPPPath path;
    @NotNull
    private final FileType fileType;
    private final int priority;
    public static final int DEFAULT_PRIORITY = 0;

    public ProjectFile(@NotNull MPPPath path2, @NotNull FileType fileType, int priority) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        this.path = path2;
        this.fileType = fileType;
        this.priority = priority;
    }

    public /* synthetic */ ProjectFile(MPPPath mPPPath, FileType fileType, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(mPPPath, fileType, n);
    }

    @Override
    @NotNull
    public MPPPath getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectFile)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getPath(), ((ProjectFile)other).getPath())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getFileType(), ((ProjectFile)other).getFileType())) {
            return false;
        }
        return this.getPriority() == ((ProjectFile)other).getPriority();
    }

    public int hashCode() {
        int result2 = this.getPath().hashCode();
        result2 = 31 * result2 + this.getFileType().hashCode();
        result2 = 31 * result2 + this.getPriority();
        return result2;
    }

    @Override
    @NotNull
    public List<Directive> fetchDirectives(boolean parseOnlyHeader) {
        List<Directive> list;
        try {
            list = Directives.extractDirectives(this.getPath().readLines(), LinearExecutor.INSTANCE.getExecutionOptions().getParseOnlyHeader(), this.getFileType());
        }
        catch (AraraIOException ioexception) {
            throw new AraraException(LanguageController.getMessages().getERROR_EXTRACTOR_IO_ERROR(), ioexception);
        }
        return list;
    }

    @NotNull
    public String toString() {
        return "ProjectFile(path=" + this.getPath() + ", fileType=" + this.getFileType() + ", priority=" + this.getPriority() + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/islandoftex/arara/core/files/ProjectFile$Companion;", "", "<init>", "()V", "DEFAULT_PRIORITY", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

