/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.utils;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import korlibs.time.DateFormat;
import korlibs.time.DateFormatKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraAPI;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.utils.StringExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "printFileInformation", "", "Lorg/islandoftex/arara/api/files/ProjectFile;", "load", "Ljava/util/Properties;", "path", "Ljava/nio/file/Path;", "charset", "Ljava/nio/charset/Charset;", "toMap", "", "", "cli"})
@SourceDebugExtension(value={"SMAP\nJVMExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMExtensions.kt\norg/islandoftex/arara/cli/utils/JVMExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1#2:104\n1193#3,2:105\n1267#3,4:107\n*S KotlinDebug\n*F\n+ 1 JVMExtensions.kt\norg/islandoftex/arara/cli/utils/JVMExtensionsKt\n*L\n102#1:105,2\n102#1:107,4\n*E\n"})
public final class JVMExtensionsKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(JVMExtensionsKt::logger$lambda$0);

    public static final void printFileInformation(@NotNull ProjectFile $this$printFileInformation) {
        Intrinsics.checkNotNullParameter($this$printFileInformation, "<this>");
        logger.info(JVMExtensionsKt::printFileInformation$lambda$1);
        logger.debug(JVMExtensionsKt::printFileInformation$lambda$2);
        String[] stringArray = new String[]{$this$printFileInformation.getPath().getFileName(), DisplayUtils.INSTANCE.byteSizeToString$cli($this$printFileInformation.getPath().getFileSize()), DateFormatKt.format-eaVjxxc(DateFormat.Companion.invoke("yyyy-MM-dd HH:mm:ss"), $this$printFileInformation.getPath().getLastModified-Wg0KzQs())};
        String it = StringExtensionsKt.formatString(LanguageController.getMessages().getINFO_DISPLAY_FILE_INFORMATION(), stringArray);
        boolean bl = false;
        logger.info(() -> JVMExtensionsKt.printFileInformation$lambda$4$lambda$3(it));
        DisplayUtils.INSTANCE.printWrapped(it);
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void load(@NotNull Properties $this$load, @NotNull Path path2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$load, "<this>");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Properties properties = $this$load;
        try {
            Properties $this$load_u24lambda_u246 = properties;
            boolean bl = false;
            Object object = path2;
            Object object2 = new OpenOption[]{};
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length)), charset), n);
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl2 = false;
                $this$load_u24lambda_u246.load(it);
                object2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            Object object3 = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
    }

    public static /* synthetic */ void load$default(Properties properties, Path path2, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        JVMExtensionsKt.load(properties, path2, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> toMap(@NotNull Properties $this$toMap) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toMap, "<this>");
        Set<Map.Entry<Object, Object>> set = $this$toMap.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair<String, String> pair = TuplesKt.to(String.valueOf(it.getKey()), String.valueOf(it.getValue()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object printFileInformation$lambda$1() {
        String[] stringArray = new String[]{AraraAPI.INSTANCE.getVersion()};
        return "\n" + StringExtensionsKt.formatString(LanguageController.getMessages().getLOG_INFO_WELCOME_MESSAGE(), stringArray) + "\n" + DisplayUtils.INSTANCE.displaySeparator();
    }

    private static final Object printFileInformation$lambda$2() {
        String[] stringArray = new String[]{Environment.getSystemProperty("java.version", "[unknown version]"), Environment.getSystemProperty("java.vendor", "[unknown vendor]"), Environment.getSystemProperty("java.home", "[unknown location]"), Environment.getSystemProperty("os.name", "[unknown OS name]"), Environment.getSystemProperty("os.arch", "[unknown OS arch]"), Environment.getSystemProperty("os.version", "[unknown OS version]"), Environment.getSystemProperty("user.home", "[unknown user's home directory]")};
        return StringExtensionsKt.formatString(StringsKt.trimIndent("\n\n            ::: arara @ " + DisplayUtils.INSTANCE.getApplicationPath$cli() + "\n            ::: Java %s, %s\n            ::: %s\n            ::: %s, %s, %s\n            ::: user.home @ %s\n            ::: CF @ " + DisplayUtils.INSTANCE.getConfigurationFileName() + "\n            " + DisplayUtils.INSTANCE.displaySeparator() + "\n        "), stringArray);
    }

    private static final Object printFileInformation$lambda$4$lambda$3(String $it) {
        return $it;
    }
}

