/*
ͻ
                    TeX-Keys  V1.2c                         
                                                            
  The enter and space bar keys have been defined to do      
  specific TeX editing features.                             
                                                            
  by Jo Koenen                                               
                                                            
ͼ
*/

compile if EVERSION >= '4.12'
;  Keyset selection is now done once at file load time, not every time
;  the file is selected.  And because the DEFLOAD procedures don't have to be
;  kept together in the macros (ET will concatenate all the DEFLOADs the
;  same way it does DEFINITs), we can put the DEFLOAD here where it belongs,
;  with the rest of the keyset function.  (what a concept!)
;

defload
compile if EPM
   universal load_var
 compile endif
   ext = filetype()
 compile if defined(MY_TEX_FILE_TYPE)
   if substr(ext,1,3)='TEX' or ext='STY' or ext='BBL' or ext=MY_TEX_FILE_TYPE then
 compile else
   if substr(ext,1,3)='TEX' or ext='STY' or ext='BBL' then
 compile endif
      keys   TEX_keys
  compile if TEX_TABS <> 0
  compile if EPM
      if not (load_var // 2) then  -- 1 would be on if tabs set from EA EPM.TABS
  compile endif
      'tabs' TEX_TABS
  compile if EPM
      endif
  compile endif
 compile endif
 compile if TEX_MARGINS <> 0
  compile if EPM
      if not (load_var%2 - 2*(load_var%4)) then  -- 2 would be on if tabs set from EA EPM.MARGINS
  compile endif
      'ma'   TEX_MARGINS
  compile if EPM
      endif
  compile endif
 compile endif
   endif
compile endif

compile if WANT_CUA_MARKING & EPM
 defkeys tex_keys clear
compile else
 defkeys tex_keys
compile endif

compile if EVERSION >= 5
def space=
compile else
def ' '=
compile endif
   universal expand_on
   if expand_on then
      if  not tex_first_expansion() then
         keyin ' '
      endif
   else
      keyin ' '
   endif
 compile if EVERSION >= '5.20'
   undoaction 1, junk                -- Create a new state
 compile endif

compile if ASSIST_TRIGGER = 'ENTER'
def enter=
 compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''  
   universal enterkey
 compile endif
compile else
def c_enter=
 compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''  
   universal c_enterkey
 compile endif
compile endif
   universal expand_on

compile if EVERSION >= 5
   if expand_on then
compile else
   if expand_on & not command_state() then
compile endif
compile if EVERSION <= '4.12'
      if tex_second_expansion() then
         call maybe_autosave()
      else
compile else
      if not tex_second_expansion() then
compile endif
compile if ASSIST_TRIGGER = 'ENTER'
 compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''  
         call enter_common(enterkey)
 compile else
         call my_enter()
 compile endif
compile else  -- ASSIST_TRIGGER
 compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''  
         call enter_common(c_enterkey)
 compile else
         call my_c_enter()
 compile endif
compile endif -- ASSIST_TRIGGER
      endif
   else
compile if ASSIST_TRIGGER = 'ENTER'
 compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''  
      call enter_common(enterkey)
 compile else
      call my_enter()
 compile endif
compile else  -- ASSIST_TRIGGER
 compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''  
      call enter_common(c_enterkey)
 compile else
      call my_c_enter()
 compile endif
compile endif -- ASSIST_TRIGGER
   endif


-------------------------------------------------------------------------------
-- Keyboard accelerators definitions for TeX


compile if TEX_WANT_ACCELERATOR_KEYS  -- some people may not want the new key defs

def c_x=       /* Force expansion if we don't have it turned on automatic */
   if not tex_first_expansion() then
      call tex_second_expansion()
   endif

def a_a= 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'eqnarray'line_r
   .col=.col+8

def a_b = 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'\begin{} \end{}'line_r
   .col=.col+7

def a_c = 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'\cite{}'line_r
   .col=.col+6

def a_f = 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'\frac{}{}'line_r
   .col=.col+6

def a_i = 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'itemize'line_r
   .col=.col+7

def a_l = 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'\label{}'line_r
   .col=.col+7

def a_m = 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'\mbox{}'line_r
   .col=.col+6

def a_q = 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'equation'line_r
   .col=.col+8

def a_r=
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'\begin{tabular}{|c|}'line_r
   insertline '\end{tabular}',.line+1
   .col=.col+19

def '{'= 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'{}'line_r
   .col=.col+1

def '$'= 
   getline line
   line_l=substr(line,1,.col-1)
   line_r=substr(line,.col)
   replaceline line_l'$$'line_r
   .col=.col+1

compile endif

-------------------------------------------------------------------------------
-- Syntax expansion code


defproc tex_first_expansion
   retc=1
compile if EVERSION >= 5
   if .line then
compile else
   if .line and (not command_state()) then
compile endif
      getline line
      line=strip(line,'T')
      line_l=substr(line,1,.col-1)
      line_r=substr(line,.col)
      linelen=length(line_l)
      if linelen > 2 then
          wrd=substr(line_l,.col-3,3)
      else
          wrd=line_l
      endif
      if wrd='\be' then
         replaceline line_l'gin{}'line_r
         if not insert_state() then insert_toggle 
compile if EVERSION >= '5.50'
             call fixup_cursor()
compile endif
         endif
         .col=.col+4
      elseif wrd='\it' then
         replaceline line_l'em 'line_r
         if not insert_state() then insert_toggle 
compile if EVERSION >= '5.50'
             call fixup_cursor()
compile endif
         endif
         .col=.col+3
      elseif wrd='\ci' then
         replaceline line_l'te{}'line_r
         if not insert_state() then insert_toggle 
compile if EVERSION >= '5.50'
             call fixup_cursor()
compile endif
         else
         endif
         .col=.col+3
      else
          retc=0
      endif
   else
      retc=0
   endif
   return retc

defproc tex_second_expansion
   retc=1
   if .line then
      getline lin
      if (.col - 19) < 0 then
         b=1
      else b=.col-19
      endif
      line=substr(lin,b,.col-b)
      parse value line with '\'wrd'{'texword'}'
      if wrd='begin' then
         insertline '\end{'texword'}',.line+1
             call einsert_line()
      else
         retc=0
      endif
   else
      retc=0
   endif
   return retc


