WEAVE change file for OpenVMS (Vax/VMS; OpenVMS for AXP and VAX)
Copyright (C) 1983 by David Fuchs.  All rights are reserved.

MODIFICATION RECORD
~~~~~~~~~~~~~~~~~~~
20-JUL-1988	BHK <tex@cran.rmcs>
	Switch off reporting of usage statistics.
	Permit WEAVEing of large things like TEX.WEB
06-SEP-1988	BHK <tex@cran.rmcs>
	Incorporate correct handling of the `::' type-cast operator.
	See UK-TeX vol.88, no. 27
21-NOV-1988	CNK <tex@cran.rmcs>
	Set |last_text_char| = 255 (from 127).
	See TeXhax vol. 88, no. 100
12-DEC-1988     BHK <tex@cran.rmcs>
	Emit VMS status on program exit
28-SEP-1989	BHK <tex@cran.rmcs>
	Modify for weave v3
29-SEP-1989	BHK <tex@cran.rmcs>
	Corrected bug which made continuation lines not perpetuate any TeX
	comment that commenced in the previous line.  (V3.0-1)
29-SEP-1989	BHK <tex@cran.rmcs>
	Prevent multiple cross-references to any particular module from within
	any one particular module. (V3.0-2)
03-NOV-1989	BHK <tex@cran.rmcs>
	Modified for V4 (eight-bit support)
10-APR-1990	BHK <tex@cran.rmcs>
	Modified for V4.1
24-SEP-1990	BHK <tex@cran.rmcs>
	Modified for V4.2
13-DEC-1991     DAH <dhosek@ymir.claremont.edu>
        Undid BHL's change of 29-SEP-1989 to prevent module lists from listing
        a module twice since it is a feature according to DEK.
03-FEB-1992	BHK <tex@cran.rmcs>
	Modified for V4.4
03-MAR-1994     SPC <spieler@linac.ikp.physik.th-darmstadt.de>
	Adapted to OpenVMS (AXP and VAX): Comment/Text changes only; program
	code is not affected.
16-JUN-1994     SPC <spieler@linac.ikp.physik.th-darmstadt.de>
	- Merged in BHK's V4.4 correction (03-FEB-1992)
	- Modified and enhanced command line handling.
24-OCT-1994     SPC <spieler@linac.ikp.physik.th-darmstadt.de>
	- Support wildcards in input file specifications.
	- Changed banner: extra version number for VMS port: [PD VMS 1.4].
07-FEB-1995     SPC <spieler@linac.ikp.physik.th-darmstadt.de>
	- Support multiple command line arguments: new function |get_argv|
	- Incremented version number for VMS port: [PD VMS 1.5].
02-APR-1995     SPC <spieler@linac.ikp.physik.th-darmstadt.de>
	- In |get_argv|, removed unused variable, and cleaned up
	  ``|argv_buf|-full'' handling (potential out of bound access!!).
28-JUN-1995     SPC <spieler@linac.ikp.physik.th-darmstadt.de>
	- In function |translate|, the index variable |k| is only used when
	  debugging mode is enabled.
	- Removed all |CHECK| attributes. Runtime checking options should be
	  specified on the compiler's command line.
03-DEC-1996   JK <knappen@vkpmzd.kph.uni-mainz.de>
        - Merged in Phil Taylor's changes for e-TeX:  
          > 15-MAR-1996     PT <P.Taylor@Vms.Rhbnc.Ac.Uk>
          >                Various sizes increased for e_TeX...
        - Changed version identification to [PD VMS 1.5-1]

{Section 0}
@x
\pageno=\contentspagenumber \advance\pageno by 1
@y
\pageno=\contentspagenumber \advance\pageno by 1
\let\maybe=\iffalse
\def\title{WEAVE changes for OpenVMS}
@z

{Section 1}
@x
@d banner=='This is WEAVE, Version 4.4'
@y
@d banner=='This is WEAVE, Version 4.4 [PD VMS 1.5-1]'
@z

{Section 2}
@x
and |change_file|, and the \TeX\ output goes to file |tex_file|.
@y
and |change_file|, and the \TeX\ output goes to file |tex_file|.
VMS requires us to mention |input| and |output| in the program header, too.
They are used for terminal input and output.
@z

{Section 2}
@x
program WEAVE(@!web_file,@!change_file,@!tex_file);
@y
program WEAVE(@!input,@!output,@!web_file,@!change_file,@!tex_file);
@z

{Section 2}
@x
  var @<Local variables for initialization@>@/
  begin @<Set initial values@>@/
@y
  var @<Local variables for initialization@>@/
  begin
  @<Preset initial values@>@/
  @<Set initial values@>@/
@z

{Section 3}
@x <<<<< Added 20-JUL-1988 by BHK <tex@cran.rmcs> >>>>>
@d stat==@{ {change this to `$\\{stat}\equiv\null$'
  when gathering usage statistics}
@d tats==@t@>@} {change this to `$\\{tats}\equiv\null$'
  when gathering usage statistics}
@y
@d stat== {empty statement}
@d tats== {another empty statement}
@z

{Section 4}
<<<<< Modified 28-JUN-1995 (SPC) Removed all runtime checking attributes. >>>>>
@x
@<Compiler directives@>=
@{@&$C-,A+,D-@} {no range check, catch arithmetic overflow, no debug overhead}
@!debug @{@&$C+,D+@}@+ gubed {but turn everything on when debugging}
@y
On OpenVMS, things are a bit different. DEC (VAX) \PASCAL's attribute
syntax for specifying compiler directives does not allow to use multiple
attribute clauses; therefore, it is not possible to switch to a different
sets of compiler directives with Web's |debug| ... |gubed| trick.
Additionally, checking attributes in the source take precedence over
command line qualifiers and cannot be overridden.
Consequently, we do not specify any global checking options; this should
be done on the compiler's command line. But we use this section
to `inherit' the descriptions of VMS system services and named constants
from the precompiled \PASCAL\ environment file |'SYS$LIBRARY:STARLET.PEN'|.

@<Compiler directives@>=
@=[inherit('sys$library:starlet')]@> {include system symbols and routines}
@z

{Section 7}
@x
@d othercases == others: {default for cases not listed explicitly}
@y
@d othercases == otherwise {OpenVMS default for cases not listed
 explicitly}
@z

{Section 8}
@x <<<<< Added 20-JUL-1988 by BHK <tex@cran.rmcs>  15-MAR-1996 14:27:03 /PT>>>>>
@!max_bytes=45000; {|1/ww| times the number of bytes in identifiers,
  index entries, and module names; must be less than 65536}
@!max_names=5000; {number of identifiers, index entries, and module names;
  must be less than 10240}
@!max_modules=2000;{greater than the total number of modules}
@!hash_size=353; {should be prime}
@!buf_size=100; {maximum length of input line}
@!longest_name=400; {module names shouldn't be longer than this}
@!long_buf_size=500; {|buf_size+longest_name|}
@!line_length=80; {lines of \TeX\ output have at most this many characters,
  should be less than 256}
@!max_refs=30000; {number of cross references; must be less than 65536}
@!max_toks=30000; {number of symbols in \PASCAL\ texts being parsed;
  must be less than 65536}
@!max_texts=2000; {number of phrases in \PASCAL\ texts being parsed;
  must be less than 10240}
@!max_scraps=1000; {number of tokens in \PASCAL\ texts being parsed}
@!stack_size=200; {number of simultaneous output levels}
@y
@!max_bytes=50000; {|1/ww| times the number of bytes in identifiers,
  index entries, and module names; must be less than 65536}
@!max_names=5000; {number of identifiers, index entries, and module names;
  must be less than 10240}
@!max_modules=2000;{greater than the total number of modules}
@!hash_size=353; {should be prime}
@!buf_size=100; {maximum length of input line}
@!longest_name=400; {module names shouldn't be longer than this}
@!long_buf_size=500; {|buf_size+longest_name|}
@!line_length=80; {lines of \TeX\ output have at most this many characters,
  should be less than 256}
@!max_refs=40000; {number of cross references; must be less than 65536}
@!max_toks=45000; {number of symbols in \PASCAL\ texts being parsed;
  must be less than 65536}
@!max_texts=5000; {number of phrases in \PASCAL\ texts being parsed;
  must be less than 10240}
@!max_scraps=3000; {number of tokens in \PASCAL\ texts being parsed}
@!stack_size=300; {number of simultaneous output levels}
@z

{Section 12}
@x
@!text_file=packed file of text_char;
@y
@!text_file=text;
@z

{Section 15}
@x <<<<< Added 06-SEP-1988 by BHK <tex@cran.rmcs> >>>>>
@d carriage_return=@'15 {ASCII code used at end of line}
@y
@d carriage_return=@'15 {ASCII code used at end of line}
@d type_cast=@'27 {equivalent to `::'}
@z

{Section 20}
<<<<<Modified 14-JUN-1994 (SPC): Comment/explanation added.>>>>>
@x
@ Terminal output is done by writing on file |term_out|, which is assumed to
consist of characters of type |text_char|:
@^system dependencies@>

@d print(#)==write(term_out,#) {`|print|' means write on the terminal}
@d print_ln(#)==write_ln(term_out,#) {`|print|' and then start new line}
@d new_line==write_ln(term_out) {start new line}
@y
@ Terminal output is done by writing on file |term_out|, which is assumed to
consist of characters of type |text_char|. On OpenVMS, the 'end of line'
characters are emitted explicitely. Implicit line feeds for |term_out|
are disabled, because |write_line| is used as |update_terminal| function
to flush the output buffer without emitting a line feed:
@^system dependencies@>

@d print(#)==write(term_out,#) {`|print|' means write on the terminal}
@d print_ln(#)==write_ln(term_out,#,chr(13),chr(10))
	{`|print|' and then start new line}
@d new_line==write_ln(term_out,chr(13),chr(10)) {start new line}
@z

{Section 21}
<<<<<Modified 14-JUN-1994 (SPC): Comment/explanation added.>>>>>
@x
@ Different systems have different ways of specifying that the output on a
certain file will appear on the user's terminal. Here is one way to do this
on the \PASCAL\ system that was used in \.{TANGLE}'s initial development:
@^system dependencies@>

@<Set init...@>=
rewrite(term_out,'TTY:'); {send |term_out| output to the terminal}
@y
@ Different systems have different ways of specifying that the output on a
certain file will appear on the user's terminal. On OpenVMS, we use the
|VAX_open| procedure to connect |term_out| with the default output device.
Implicit carriage control is disabled to allow the use of |write_ln| to
flush the output buffer without sending a line feed.

@<Set init...@>=
VAX_open(term_out,'SYS$OUTPUT',@=carriage_control:=none@>);
rewrite(term_out);
@z

{Section 22}
@x
@d update_terminal == break(term_out) {empty the terminal output buffer}
@y
@d update_terminal == write_ln(term_out) {empty the terminal output buffer}
@z

{Section 27}
@x
@ Input goes into an array called |buffer|.

@<Globals...@>=@!buffer: array[0..long_buf_size] of ASCII_code;
@y
@ Input goes into an array called |buffer|.
Actually, it is first read into |temp_buffer|.

@<Globals...@>=@!buffer: array[0..long_buf_size] of ASCII_code;
@!temp_buffer: varying [buf_size] of char;
@z

{Section 28}
@x <<<<<Modified 28-SEP-1989 by BHK <tex@cran.rmcs> : V3 WEB has changed>>>>>
@p function input_ln(var f:text_file):boolean;
  {inputs a line or returns |false|}
var final_limit:0..buf_size; {|limit| without trailing blanks}
begin limit:=0; final_limit:=0;
if eof(f) then input_ln:=false
else  begin while not eoln(f) do
    begin buffer[limit]:=xord[f^]; get(f);
    incr(limit);
    if buffer[limit-1]<>" " then final_limit:=limit;
    if limit=buf_size then
      begin while not eoln(f) do get(f);
      decr(limit); {keep |buffer[buf_size]| empty}
      if final_limit>limit then final_limit:=limit;
      print_nl('! Input line too long'); loc:=0; error;
@.Input line too long@>
      end;
    end;
  read_ln(f); limit:=final_limit; input_ln:=true;
  end;
end;
@y
On OpenVMS we first read a line into |temp_buffer|, since that's faster.

@p function input_ln(var f:text_file):boolean;
  {inputs a line or returns |false|}
var i,@!l:0..buf_size;
begin limit:=0;
if eof(f) then input_ln:=false
else  begin
	read(f,temp_buffer);
	l:=temp_buffer.@=length@>;
	for i:=1 to l do begin
		buffer[i-1]:=xord[temp_buffer[i]];
		if buffer[i-1]<>" " then limit:=i;
		end;
	if not eoln(f) then begin
		print_nl('! Input line too long'); error;
@.Input line too long@>
		end
	else read_ln(f);
	input_ln:=true;
	end;
end;
@z

{Section 51}
<<<<< Added 29-SEP-1989 by BHK <tex@cran.rmcs> : correct multiple xrefs>>>>>
>>>>> Deleted 13-DEC-1991 by DAH <dhosek@ymir.claremont.edu> : It's a feature!
@ x
@p procedure new_mod_xref(@!p:name_pointer);
var q,@!r:xref_number; {pointers to previous cross references}
begin q:=xref[p]; r:=0;
if q>0 then
  begin if mod_xref_switch=0 then while num(q)>=def_flag do
    begin r:=q; q:=xlink(q);
    end
  else if num(q)>=def_flag then
    begin r:=q; q:=xlink(q);
    end;
  end;
append_xref(module_count+mod_xref_switch); xlink(xref_ptr):=q;
mod_xref_switch:=0;
if r=0 then xref[p]:=xref_ptr
else xlink(r):=xref_ptr;
end;
@ y
@p procedure new_mod_xref(@!p:name_pointer);
label exit;
var q,@!r:xref_number; {pointers to previous cross references}
begin q:=xref[p]; r:=0;
if q>0 then
  begin if mod_xref_switch=0 then while num(q)>=def_flag do
    begin r:=q; q:=xlink(q);
    end
  else if num(q)>=def_flag then
    begin r:=q; q:=xlink(q);
    end;
  end;
if num(q) = module_count+mod_xref_switch then return;
append_xref(module_count+mod_xref_switch); xlink(xref_ptr):=q;
mod_xref_switch:=0;
if r=0 then xref[p]:=xref_ptr
else xlink(r):=xref_ptr;
exit:
end;
@ z

{Section 97}
@x <<<<< Added 06-SEP-1988 by BHK <tex@cran.rmcs> >>>>>
":": if buffer[loc]="=" then compress(left_arrow);
@y
":": if buffer[loc]="=" then compress(left_arrow)
else if buffer[loc]=":" then compress(type_cast);
@z

{Section 122}
<<<<<Modified 29-SEP-1989 by BHK <tex@cran.rmcs> : fix comment continuation>>>>>
<<<<<Modified 03-FEB-1992 by BHK <tex@cran.rmcs> : fix now in V4.4 source>>>>>
@x
done: for k:=1 to j do write(tex_file,xchr[out_buf[k]]);
if per_cent then write(tex_file,xchr["%"]);
write_ln(tex_file); incr(out_line);
@y
done: for k:=1 to j do out_temp_buffer[k]:=xchr[out_buf[k]];
k:=j;
if per_cent then begin incr(k); out_temp_buffer[k]:=xchr["%"]; end;
write_ln(tex_file,substr(out_temp_buffer,1,k)); incr(out_line);
@z

{Section 179}
<<<<<Added 28-JUN-1995 (SPC): Variable |k| only used in debugging code.>>>>>
@x
@!j:0..max_scraps; {runs through final scraps}
@!k:0..long_buf_size; {index into |buffer|}
begin pp:=scrap_base; lo_ptr:=pp-1; hi_ptr:=pp;
@y
@!j:0..max_scraps; {runs through final scraps}
@!debug@!k:0..long_buf_size; {index into |buffer|}
gubed
begin pp:=scrap_base; lo_ptr:=pp-1; hi_ptr:=pp;
@z

{Section 186}
@x <<<<< Added 06-SEP-1988 by BHK <tex@cran.rmcs> >>>>>
":": sc1(":")(colon);
@y
":": sc1(":")(colon);
type_cast: sc2(":")(":")(math);
@z

{Section 258}
@x
@!term_in:text_file; {the user's terminal as an input file}
@y
@z

{Section 259}
@x
@ The debugging routine needs to read from the user's terminal.
@^system dependencies@>
@<Set init...@>=
@y
@ The debugging routine needs to read from the user's terminal.
@^system dependencies@>
@d term_in==input

@<Set init...@>=
@z

{Section 259}
@x
trouble_shooting:=false; debug_cycle:=99999; {use these when it almost works}
reset(term_in,'TTY:','/I'); {open |term_in| as the terminal, don't do a |get|}
gubed
@y
trouble_shooting:=false; debug_cycle:=99999; {use these when it almost works}
gubed
@z

{Section 261}
@x
@t\4\4@>{here files should be closed if the operating system requires it}
@y
if history<fatal_message then
	@= close@>(tex_file,VAX_disposition_save,VAX_ignore_error);
@z

{Section 263}
@x <<<<< Added 12-DEC-1988 by BHK <tex@cran.rmcs> >>>>>
@ Some implementations may wish to pass the |history| value to the
operating system so that it can be used to govern whether or not other
programs are started. Here we simply report the history to the user.
@^system dependencies@>

@<Print the job |history|@>=
case history of
spotless: print_nl('(No errors were found.)');
harmless_message: print_nl('(Did you see the warning message above?)');
error_message: print_nl('(Pardon me, but I think I spotted something wrong.)');
fatal_message: print_nl('(That was a fatal error, my friend.)');
end {there are no other cases}
@y
@ This implementation passes the |history| value to the
operating system so that it can be used to govern whether or not other
programs are started; we also report the history to the user here.
@^system dependencies@>

@d VAX_exit==@=$exit@>
@d VAX_ss_normal==@= sts$k_success @>
@d VAX_ss_warning==@= sts$k_warning + sts$m_inhib_msg @>
@d VAX_ss_error==@= sts$k_error + sts$m_inhib_msg @>
@d VAX_ss_fatal==@= sts$k_severe + sts$m_inhib_msg @>

@<Print the job |history|@>=
case history of
spotless: begin print_nl('(No errors were found.)');
   VAX_exit(VAX_ss_normal) end;	{ Everything OK! }
harmless_message: begin print_nl('(Did you see the warning message above?)');
   VAX_exit(VAX_ss_warning) end;
error_message: begin
   print_nl('(Pardon me, but I think I spotted something wrong.)');
   VAX_exit(VAX_ss_error) end;
fatal_message: begin print_nl('(That was a fatal error, my friend.)');
   VAX_exit(VAX_ss_fatal) end;
end {there are no other cases}
@z


{Section 264 et seq}
<<<<<Modified 16-JUN-1994 (SPC): Enhanced filename handling.>>>>>
<<<<<Modified 24-OCT-1994 (SPC): Support wildcards in file names.>>>>>
<<<<<Modified 07-FEB-1995 (SPC): Support multiple command arguments.>>>>>
@x
This module should be replaced, if necessary, by changes to the program
that are necessary to make \.{WEAVE} work at a particular installation.
It is usually best to design your change file so that all changes to
previous modules preserve the module numbering; then everybody's version
will be consistent with the printed program. More extensive changes,
which introduce new modules, can be inserted here; then only the index
itself will get a new module number.
@y
Here are the remaining changes to the program
that are necessary to make \.{WEAVE} work on OpenVMS.

@ This variable is for speeding up the output routine.

@<Glob...@>=
@!out_temp_buffer: packed array [1..line_length+1] of char;

@ The following definitions are used in the parameter specifications to
the OpenVMS specific |VAX_open| predeclared \PASCAL\ routine to get
access to the supported RMS features.

@d VAX_open==@= open@>
@#
@d VAX_new==@= new @>
@d VAX_readonly==@= readonly @>
@#
@d VAX_user_action==@=user_action@>
@#
@d VAX_disposition_delete==@=disposition:=delete@>
@d VAX_disposition_save==@=disposition:=save@>
@#
@d VAX_ignore_error==@=error:=continue@>

@ On OpenVMS we need the following special definitions, types, variables
and procedures to be able to get the file name from the command line,
or to prompt for them.

@d VAX_status==@=status@>
@d VAX_unsafe==@=unsafe@>
@d VAX_volatile==@=volatile@>
@d VAX_immed==@=%immed @>
@d VAX_external==@=external@>
@d VAX_ref==@=%ref @>
@d VAX_stdescr==@=%stdescr @>
@d VAX_lib_get_foreign==@= lib$get_foreign@>
@#
@d VAX_varying_length==@=length @>
@d VAX_varying_body==@=body@>
@#
@d VAX_rms_parse==@= $parse@>
@d VAX_rms_search==@= $search@>
@d VAX_rms_open==@= $open@>
@d VAX_rms_connect==@= $connect@>
@d VAX_fab_type==@= FAB$TYPE @>
@d VAX_rab_type==@= RAB$TYPE @>
@d VAX_nam_type==@= NAM$TYPE @>
@d VAX_FAB_V_NAM==@=FAB$V_NAM@>
@d VAX_FAB_L_NAM==@=FAB$L_NAM@>
@d VAX_NAM_B_RSL== @=NAM$B_RSL @>
@d VAX_NAM_L_RSA== @=NAM$L_RSA @>
@d VAX_NAM_B_NODE==@=NAM$B_NODE @>
@d VAX_NAM_L_NODE==@=NAM$L_NODE @>
@d VAX_NAM_B_DEV==@=NAM$B_DEV @>
@d VAX_NAM_L_DEV==@=NAM$L_DEV @>
@d VAX_NAM_B_DIR==@=NAM$B_DIR @>
@d VAX_NAM_L_DIR==@=NAM$L_DIR @>
@d VAX_NAM_B_NAME==@=NAM$B_NAME @>
@d VAX_NAM_L_NAME==@=NAM$L_NAME @>
@d VAX_NAM_B_TYPE==@=NAM$B_TYPE @>
@d VAX_NAM_L_TYPE==@=NAM$L_TYPE @>
@d VAX_NAM_B_VER==@=NAM$B_VER @>
@d VAX_NAM_L_VER==@=NAM$L_VER @>
@#
@f extern==forward
@f varying==array

@<Types...@>=
unsafe_file = [VAX_unsafe] file of char;
FAB_ptr = ^VAX_fab_type;
RAB_ptr = ^VAX_rab_type;
NAM_ptr = ^VAX_nam_type;
charptr = ^char;

@ This section declares the variables used for the command line interface:

@d max_args = 3

@<Local variables for init...@>=
@!argc : integer ; {number of command line arguments found}
@!argv : packed array[0..max_args] of integer ; {pointers to arg substrings}
@!arg_buffer : packed array[1..300] of char ; {buffer for command line args}
@!file_name,@!default_file_name:varying [300] of char;
@!def_pathname:varying [300] of char;
@!def_basename,@!def_fileextension:varying [32] of char;
@!def_fileversion:varying[16] of char;
@!ask,@!got_file_name: boolean;

@ The following global string variables are used by the user defined
action routine (called during |VAX_open| processing) to return the
name components of the actual file accessed.

@<Global...@>=
@!command_line : packed array[1..300] of char ; {command line}
@!cmd_len : sixteen_bits ; {length of a command line}
@!act_pathname:varying [300] of char;
@!act_basename,@!act_fextension:varying [32] of char;
@!act_fversion:varying[16] of char;

@ Here is the library procedure that gets the user's command line.

@<Error handling...@>=
[VAX_external] function VAX_lib_get_foreign(
  VAX_stdescr cmdlin:[VAX_volatile] packed array [$l1..$u1:integer] of char
	:= VAX_immed 0;
  VAX_stdescr prompt:[VAX_volatile] packed array [$l2..$u2:integer] of char
	:= VAX_immed 0;
  var len : [VAX_volatile] sixteen_bits := VAX_immed 0;
  var flag : [VAX_volatile] integer := VAX_immed 0)
    :integer; extern;

@ This function gets the command line tail string and splits it up
  into individual arguments. Command line arguments are separated
  by white space (one or more blanks).
  Quoted strings are recognized, too! (Arguments that contain mixed case
  characters or embedded spaces have to be enclosed in double quotes.)
  To facilitate potential mixture with modules programmed in C, the processed
  argument strings are terminated by a NUL character.

@d check_argbuf_space==begin
       if (arg_i >= argb_u) then begin
          get_argv:=-1;
          return;
       end;
   end

@<Error handling...@>=
function get_argv(
	var @!argv: packed array[argv_l..argv_u:integer] of integer;
	var @!arg_buf: packed array[argb_l..argb_u:integer] of char)
    : integer;
{ returns the number of arguments found, or -1 in case of errors }
label exit;
var
  @!cmd_i : integer ; {command line pointers}
  @!arg_i : integer ; {|arg_buf| pointer}
  @!arg_max : integer ; {maximum number of arguments allowed}
  @!arg_cnt : integer ; {argument counter}
  @!in_quoted_string : boolean ; {flag ``inside quoted string''}
  @!c : char ;
begin
  arg_max := (argv_u - argv_l);
  cmd_i:=0;
  VAX_lib_get_foreign(command_line,,cmd_len,cmd_i);
  cmd_i:=1;
  arg_i:=argb_l;
  arg_cnt:=0;
  argv[argv_l]:=arg_i;
  while ((arg_cnt < arg_max) and
         (cmd_i <= cmd_len)) do begin

    { advance to next nonblank character }
      while (cmd_i<=cmd_len) and (command_line[cmd_i]=' ') do incr(cmd_i);

    { copy characters into |arg_buf| }
      while (cmd_i<=cmd_len) and (command_line[cmd_i]<>' ') do begin
          c:=command_line[cmd_i]; incr(cmd_i);
          if (c='"') then begin
              in_quoted_string:=true;
              while (cmd_i<=cmd_len) and (in_quoted_string) do begin
                  c:=command_line[cmd_i]; incr(cmd_i);
                  if (c='"') then begin
                      c:=command_line[cmd_i];
                      if (c='"') then begin
                        { add double quote to argument string}
                          incr(cmd_i);
                          check_argbuf_space;
                          arg_buf[arg_i]:=c; incr(arg_i);
                      end
                      else begin
                        { end of quoted string }
                          in_quoted_string:=false;
                      end;
                  end
                  else begin
                      check_argbuf_space;
                      arg_buf[arg_i]:=c; incr(arg_i);
                  end;
              end;
          end
          else begin
              check_argbuf_space;
              arg_buf[arg_i]:=c; incr(arg_i);
          end;
      end;

    { append `NUL' character to |arg_buf| }
      arg_buf[arg_i]:=chr(0); incr(arg_i);

    { record location of the just copied argument in argv }
      incr(arg_cnt);
      argv[argv_l+arg_cnt]:=arg_i;
  end;
  get_argv:=arg_cnt;
exit: end;

@ The following procedure splits the specification of an external file into
  its components.

@<Error handling...@>=
procedure split_filename(@!fname:varying[len1] of char;
	var @!f_pathname:varying [len2] of char;
	var @!f_basename:varying [len3] of char;
	var @!f_extension:varying [len4] of char;
	var @!f_version:varying [len5] of char);
var b,@!e,@!v,@!t,@!i:integer;
begin
    b:=1;  {find end of any leading path specification}
    for i:=1 to fname.VAX_varying_length do
	if (fname[i]=']') or (fname[i]=':')
	then b:=i+1;
    e:=0; {find end of base name}
    for i:=b to fname.VAX_varying_length do
	if (e=0) and @/
	    ((fname[i]='.') or (fname[i]=' '))
	then e:=i;
    if e=0 then e:=fname.VAX_varying_length+1;
    v:=0; {find end of file extension}
    for i:=e+1 to fname.VAX_varying_length do
	if (v=0) and @/
	    ((fname[i]='.') or (fname[i]=';') or (fname[i]=' '))
	then v:=i;
    if v=0 then v:=fname.VAX_varying_length+1;
    t:=0; {strip off any trailing blanks}
    for i:=v+1 to fname.VAX_varying_length do
	if (t=0) and (fname[i]=' ')
	then t:=i;
    if t=0 then t:=fname.VAX_varying_length+1;
    f_pathname:=substr(fname,1,b-1);
    f_basename:=substr(fname,b,e-b);
    f_extension:=substr(fname,e,v-e);
    f_version:=substr(fname,v,t-v);
end;

@ The function |user_open_wild| is called as |VAX_user_action| routine when
  opening a file for reading. It extends the default action when
  executiong a |VAX_open| call to support wildcards in file names.
  Additionally, the string variables |act_pathname|, |act_basename|,
  |act_fextension|, and |act_fversion| are set to the respective parts
  of the actually opened file's name.

@<Error handling...@>=
function user_open_wild(
      var fab:VAX_fab_type;
      var rab:VAX_rab_type;
      var F:unsafe_file):integer;
var	sts:integer;
        NAM:NAM_ptr;
        p:charptr;
        i:integer;
begin
    sts:=VAX_rms_parse(fab);
    if odd(sts) then begin
      sts:=VAX_rms_search(fab);
      if odd(sts) then
        fab.VAX_FAB_V_NAM:=true;
      sts:=VAX_rms_open(fab);
      if odd(sts) then begin
        sts:=VAX_rms_connect(rab);
        if odd(sts) then begin
          NAM:=fab.VAX_FAB_L_NAM::NAM_ptr;
          if NAM<>nil then begin
            act_pathname.VAX_varying_length:=NAM^.VAX_NAM_B_NODE+
                  NAM^.VAX_NAM_B_DEV+NAM^.VAX_NAM_B_DIR;
            for i:=1 to act_pathname.VAX_varying_length do begin
               p:=(NAM^.VAX_NAM_L_RSA::integer+i-1)::charptr;
               act_pathname.VAX_varying_body[i]:=p^;
            end;
            act_basename.VAX_varying_length:=NAM^.VAX_NAM_B_NAME;
            for i:=1 to NAM^.VAX_NAM_B_NAME do begin
               p:=(NAM^.VAX_NAM_L_NAME::integer+i-1)::charptr;
               act_basename.VAX_varying_body[i]:=p^;
            end;
            act_fextension.VAX_varying_length:=NAM^.VAX_NAM_B_TYPE;
            for i:=1 to NAM^.VAX_NAM_B_TYPE do begin
               p:=(NAM^.VAX_NAM_L_TYPE::integer+i-1)::charptr;
               act_fextension.VAX_varying_body[i]:=p^;
            end;
            act_fversion.VAX_varying_length:=NAM^.VAX_NAM_B_VER;
            for i:=1 to NAM^.VAX_NAM_B_VER do begin
               p:=(NAM^.VAX_NAM_L_VER::integer+i-1)::charptr;
               act_fversion.VAX_varying_body[i]:=p^;
            end;
          end;
        end;
      end;
    end;
    user_open_wild:=sts;
end;

@ We get the external file names, and then call |VAX_open|
to associate an external file with each file variable.

@<Preset init...@>=
argc:=get_argv(argv,arg_buffer);
got_file_name:=(argc > 0);

if got_file_name then begin
	file_name:=substr(arg_buffer,argv[0],argv[1]-argv[0]-1);
	split_filename(file_name,
		def_pathname,def_basename,def_fileextension,def_fileversion);
	default_file_name:=def_pathname+def_basename;
	if def_fileextension = '' then
	    file_name:=default_file_name+'.WEB'
	else
	    file_name:=default_file_name+def_fileextension;
	if def_fileversion <> '' then
	    file_name:=file_name+def_fileversion;
	VAX_open(web_file,file_name,VAX_readonly,
                 VAX_user_action:=user_open_wild,VAX_ignore_error);
	ask:=VAX_status(web_file)<>0;
	if ask then write_ln('Couldn''t open ',file_name);
	end
else ask:=true;
while ask do begin
	got_file_name:=false;
	write('Web file [.WEB]: ');
	if eof then begin mark_fatal; jump_out; end;
	read_ln(file_name);
	split_filename(file_name,
		def_pathname,def_basename,def_fileextension,def_fileversion);
	if def_fileextension = '' then
	    file_name:=def_pathname+def_basename+'.WEB'+def_fileversion;
	VAX_open(web_file,file_name,VAX_readonly,
                 VAX_user_action:=user_open_wild,VAX_ignore_error);
	ask:=VAX_status(web_file)<>0;
	if ask then write_ln('Couldn''t open ',file_name);
	end;

if def_pathname<>'' then def_pathname:=act_pathname;
def_basename:=act_basename;
def_fileextension:=act_fextension;
def_fileversion:=act_fversion;
default_file_name:=def_pathname+def_basename;

if got_file_name then begin
	if (argc>=2) then begin
		file_name:=substr(arg_buffer,argv[1],argv[2]-argv[1]-1);
		split_filename(file_name,
			act_pathname,act_basename,act_fextension,act_fversion);
		if act_fextension = '' then
		    file_name:=act_pathname+act_basename+'.CH'+act_fversion;
		end
	else begin
		file_name:=default_file_name+'.CH';
		end;
	VAX_open(change_file,file_name,VAX_readonly,
                 VAX_user_action:=user_open_wild,VAX_ignore_error);
	ask:=VAX_status(change_file)>0; {can be empty}
	if ask then write_ln('Couldn''t open ',file_name);
	end
else ask:=true;
while ask do begin
	write('Change file [NL:]: ');
	if eof then begin mark_fatal; jump_out; end;
	read_ln(file_name);
	if file_name.VAX_varying_length=0 then file_name:='NL:';
	VAX_open(change_file,file_name,VAX_readonly,
                 VAX_user_action:=user_open_wild,VAX_ignore_error);
	ask:=VAX_status(change_file)>0;
	if ask then write_ln('Couldn''t open ',file_name);
	end;

if got_file_name then begin
	if (argc>=3) then begin
		file_name:=substr(arg_buffer,argv[2],argv[3]-argv[2]-1);
		split_filename(file_name,
			act_pathname,act_basename,act_fextension,act_fversion);
		if act_fextension = '' then
		    file_name:=act_pathname+act_basename+'.TEX'+act_fversion;
		end
	else begin
		file_name:=def_basename+'.TEX';
		end;
	VAX_open(tex_file,file_name,VAX_new,VAX_disposition_delete,
		VAX_ignore_error);
	ask:=VAX_status(tex_file)>0;
	if ask then write_ln('Couldn''t open ',file_name);
	end
else ask:=true;
while ask do begin
	write('TeX file [',def_basename,'.TEX]: ');
	if eof then begin mark_fatal; jump_out; end;
	read_ln(file_name);
	if file_name.VAX_varying_length=0 then file_name:=def_basename+'.TEX';
	VAX_open(tex_file,file_name,VAX_new,VAX_disposition_delete,
		VAX_ignore_error);
	ask:=VAX_status(tex_file)>0;
	if ask then write_ln('Couldn''t open ',file_name);
	end;
@z
