#!/usr/bin/perl
#
# This perl script converts the Czech hyphenation pattern as distributed
# on the CTAN network from the PC encoding into a form usable by LaTeX2e
# with T1 fontencoding (DC fonts).
#
# Version 1.0 (10-Dec-1995)
#
# written by Werner Lemberg <a7621gac@awiuni11.bitnet>
#
#
# Usage: perl czhyph2e.pl < czhyphen.tex > czhyph2e.tex
#

$\ = "\n"; # output record separator

%conv_852_to_DC = ( "\x82", 0351,     # e ' (acute)
                    "\x85", 0267,     # u Ring
                    "\x9c", 0264,     # t Hacek
                    "\x9f", 0243,     # c Hacek 
                    "\xa0", 0341,     # a '
                    "\xa1", 0355,     # i '
                    "\xa2", 0363,     # o '
                    "\xa3", 0372,     # u '
                    "\xa7", 0272,     # z Hacek
                    "\xd4", 0244,     # d Hacek
                    "\xd8", 0245,     # e Hacek
                    "\xe5", 0254,     # n Hacek
                    "\xe7", 0262,     # s Hacek
                    "\xec", 0375,     # y '
                    "\xfd", 0260 );   # r Hacek


$_ = <>; chop; print;   # print the first line
<>;                     # discard second line

print '%';
print "\\message{Czech Hyphenation Patterns `czhyph2e'}";
print '%';
print '% mechanically translated from czhyphen.tex';
print '% using the perl script czhyph2e.pl';
print '%';
print '\begingroup';
print '  \def\x{%';
print '    \endgroup';
print '    \catcode"A3=11 \lccode"A3="A3   % c hacek';
print '    \catcode"A4=11 \lccode"A4="A4   % d hacek';
print '    \catcode"A5=11 \lccode"A5="A5   % e hacek';
print '    \catcode"AC=11 \lccode"AC="AC   % n hacek';
print '    \catcode"B0=11 \lccode"B0="B0   % r hacek';
print '    \catcode"B2=11 \lccode"B2="B2   % s hacek';
print '    \catcode"B4=11 \lccode"B4="B4   % t hacek';
print '    \catcode"B7=11 \lccode"B7="B7   % u ring';
print '    \catcode"BA=11 \lccode"BA="BA   % z hacek';
print '    \catcode"E1=11 \lccode"E1="E1   % a acute';
print '    \catcode"E9=11 \lccode"E9="E9   % e acute';
print '    \catcode"ED=11 \lccode"ED="ED   % i acute';
print '    \catcode"F3=11 \lccode"F3="F3   % o acute';
print '    \catcode"FA=11 \lccode"FA="FA   % u acute';
print '    \catcode"FD=11 \lccode"FD="FD}  % y acute';
print '\x';
print '%';
print '%';


while (<>) {
    chop;                   # strip record separator
    @Fld = split(//, $_);   # split into single characters

    if ($Fld[0] eq '%' && $Fld[1] ne "\x1a") {
        print $_;           # print comment lines unchanged
    }
    else {
        $string = '';
        foreach $char (@Fld) {
            $string .= ($char lt "\x80") ? 
                         $char :
                         ('^^' . sprintf("%x", $conv_852_to_DC{$char}));
        }
        print $string;
    }
}


print '%';
print '\endinput';

#
# end of czhyph2e.pl
#
