/*
 * Decompiled with CFR 0.152.
 */
package installer;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class MakeFileList {
    static int sizeInBytes;
    static String PREFIX_DIR;

    public static void main(String[] args) {
        String[] dirList = new String[]{"COPYING.txt", "readme.html", "quickstart.html", "lang", "lib"};
        MakeFileList.makeFileList(dirList, "installer" + File.separator + "jpicedt-program");
        dirList = new String[]{"help-files"};
        MakeFileList.makeFileList(dirList, "installer" + File.separator + "jpicedt-help");
        dirList = new String[]{"macros"};
        MakeFileList.makeFileList(dirList, "installer" + File.separator + "jpicedt-macros");
        dirList = new String[]{"add-ons"};
        MakeFileList.makeFileList(dirList, "installer" + File.separator + "jpicedt-addons");
        dirList = new String[]{"fragments"};
        MakeFileList.makeFileList(dirList, "installer" + File.separator + "jpicedt-fragments");
    }

    static void makeFileList(String[] directories, String outFile) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(PREFIX_DIR + outFile)));
            sizeInBytes = 0;
            int i = 0;
            while (i < directories.length) {
                ArrayList al = MakeFileList.lsR(new File(PREFIX_DIR + directories[i]));
                Iterator it = ((AbstractList)al).iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    s = s.substring(PREFIX_DIR.length());
                    writer.println(s);
                }
                ++i;
            }
            writer.flush();
            writer.close();
            System.out.println(outFile + " : " + (int)((double)sizeInBytes / 1024.0) + "k");
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            System.exit(0);
        }
    }

    static ArrayList lsR(File directory) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (directory.isFile()) {
            fileList.add(directory.getPath());
            int sz = MakeFileList.fileSizeBytes(directory);
            sizeInBytes += sz;
            return fileList;
        }
        File[] dirContent = directory.listFiles();
        if (dirContent == null) {
            return fileList;
        }
        int i = 0;
        while (i < dirContent.length) {
            if (dirContent[i].isDirectory()) {
                ArrayList subDirFileList = MakeFileList.lsR(dirContent[i]);
                Iterator it = ((AbstractList)subDirFileList).iterator();
                while (it.hasNext()) {
                    fileList.add((String)it.next());
                }
            } else {
                fileList.add(dirContent[i].getPath());
                int sz = MakeFileList.fileSizeBytes(dirContent[i]);
                sizeInBytes += sz;
            }
            ++i;
        }
        return fileList;
    }

    static int fileSizeBytes(File file) {
        try {
            int count;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 32768);
            int bytes = 0;
            while ((count = is.read()) != -1) {
                ++bytes;
            }
            is.close();
            return bytes;
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            System.exit(0);
            return 0;
        }
    }

    static {
        PREFIX_DIR = "dist" + File.separator;
    }
}

