%&latex
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% This is the file testmath.mk, part of the MathKit package
%% (version 0.7, January , 1998) for math font 
%% generation.  (Author: Alan Hoenig, ajhjj@cunyvm.cuny.edu)
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\documentclass{article} 

\renewcommand{\encodingdefault}{OT1}

\usepackage{z<mock><fam>} 

\title{A \LaTeX\ math test document} 
\author{for fonts installed by MathKit}

\raggedbottom 

\font\TTT=cmr7 \newcount\cno
\def\TT{\T\setbox0=\hbox{\char\cno}\ifdim\wd0>0pt
   \box0\lower4pt\hbox{\TTT\the\cno}\else
   \ifdim\ht0>0pt \box0\lower4pt\hbox{\TTT\the\cno}\fi\fi
   \global\advance\cno by1
}
\def\showfont#1{\font\T=#1 at 10pt\global\cno=0
 \tabskip1pt plus2pt minus1pt\halign to\textwidth{&\hss\TT ##\hss\cr
 \multispan{16}\hfil \tt Font #1\hfil\cr\noalign{\smallskip}
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
}}
\newcommand{\testsize}[1]{ 
   #1 \texttt{\string#1}: \(a_{c_e}, b_{d_f}, C_{E_G}, 0_{1_2}, 
      a_{0_a}, 0_{a_0}, 
      \sum_{i=0}^\infty\) \\ 
} 

\newcommand{\testdelims}[3]{\sqrt{ 
   #1|#1\|#1\uparrow 
   #1\downarrow#1\updownarrow#1\Uparrow#1\Downarrow 
   #1\Updownarrow#1\lfloor#1\lceil 
   #1(#1\{#1[#1\langle 
      #3 
   #2\rangle#2]#2\}#2) 
   #2\rceil#2\rfloor#2\Updownarrow#2\Downarrow 
   #2\Uparrow#2\updownarrow#2\downarrow#2\uparrow 
   #2\|#2| 
}\\} 

\newcommand{\testglyphs}[1]{ 
\begin{quote} 
   #1a#1b#1c#1d#1e#1f#1g#1h#1i#1j#1k#1l#1m 
   #1n#1o#1p#1q#1r#1s#1t#1u#1v#1w#1x#1y#1z 
   #1A#1B#1C#1D#1E#1F#1G#1H#1I#1J#1K#1L#1M 
   #1N#1O#1P#1Q#1R#1S#1T#1U#1V#1W#1X#1Y#1Z 
   #10#11#12#13#14#15#16#17#18#19 
   #1\Gamma#1\Delta#1\Theta#1\Lambda#1\Xi 
   #1\Pi#1\Sigma#1\Upsilon#1\Phi#1\Psi#1\Omega 
   #1\alpha#1\beta#1\gamma#1\delta#1\epsilon 
   #1\varepsilon#1\zeta#1\eta#1\theta#1\vartheta 
   #1\iota#1\kappa#1\lambda#1\mu#1\nu#1\xi#1\omicron 
   #1\pi#1\varpi#1\rho#1\varrho 
   #1\sigma#1\varsigma#1\tau#1\upsilon#1\phi 
   #1\varphi#1\chi#1\psi#1\omega 
   #1\partial#1\ell#1\imath#1\jmath#1\wp 
\end{quote} 
} 

\newcommand{\sidebearings}[1]{ \(|#1|\) } 
\newcommand{\subscripts}[1]{ \(#1_\circ\) } 
\newcommand{\supscripts}[1]{ \(#1^\circ\) } 
\newcommand{\scripts}[1]{ \(#1^\circ_\circ\) } 
\newcommand{\vecaccents}[1]{ \(\vec#1\) } 
\newcommand{\tildeaccents}[1]{ \(\tilde#1\) } 

\ifx\omicron\undefined 
   \let\omicron=o 
\fi 

\begin{document} 

\maketitle 

\subsection*{Introduction} 

This document tests the math capabilities of a math package, and is 
strongly modelled after a similar document by Alan Jeffrey.  
This test exercises the {\tt <mock>} math fonts combined with the
{\tt <fam>} text fonts.

\showfont{<fam>r<m>7t}	
\smallskip			     
\showfont{<fam>r<m>7m}
\smallskip
\showfont{<mock>sy10}
\smallskip
\showfont{<mock>ex10}
\smallskip

\subsection*{Fonts} 

Math italic: 
\[ 
   ABCDEFGHIJKLMNOPQRSTUVWXYZ 
   abcdefghijklmnopqrstuvwxyz 
\] 
Text italic: 
\[ 
   \mathit{ABCDEFGHIJKLMNOPQRSTUVWXYZ 
      abcdefghijklmnopqrstuvwxyz} 
\] 
Roman: 
\[ 
   \mathrm{ABCDEFGHIJKLMNOPQRSTUVWXYZ 
      abcdefghijklmnopqrstuvwxyz} 
\] 
[b]Bold: 
[b]\[ 
[b]   \mathbf{ABCDEFGHIJKLMNOPQRSTUVWXYZ 
[b]	 abcdefghijklmnopqrstuvwxyz} 
[b]\] 
[b]{\mathversion{boldmath}
[b]\[
[b]	 \Gamma\Delta\Theta\Lambda\Xi\Pi\Sigma
[b]	 \Upsilon\Phi\Psi\Omega
[b]\]}
[tt]Typewriter: 
[tt]\[ 
[tt]   \mathtt{ABCDEFGHIJKLMNOPQRSTUVWXYZ 
[tt]	  abcdefghijklmnopqrstuvwxyz} 
[tt]\] 
Greek: 
\[ 
   \Gamma\Delta\Theta\Lambda\Xi\Pi\Sigma\Upsilon\Phi\Psi\Omega 
  \alpha\beta\gamma\delta\epsilon\varepsilon\zeta\eta\theta\vartheta 
   \iota\kappa\lambda\mu\nu\xi\omicron\pi\varpi\rho\varrho 
   \sigma\varsigma\tau\upsilon\phi\varphi\chi\psi\omega 
\] 
Calligraphic:
\[A\mathcal{ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z\]
Sans: 
\[ 
   A\mathsf{ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z \quad 
      a\mathsf{abcdefghijklmnopqrstuvwxyz}z 
\] 
[fr]Fraktur:
[fr]\[
[fr]   A\mathfr{ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z \quad
[fr]   a\mathfr{abcdefghijklmnopqrstuvwxyz}z 
[fr]\]
[bb]Blackboard Bold: 
[bb]\[ 
[bb]   A\mathbb{ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z
[bb]\] 
Do these line up appropriately? 
\[ 
   \forall \mathcal{B} \Gamma 
[b]\mathbf{D} 
   \exists 
[tt]\mathtt{F} 
   G \mathcal{H} \Im 
[b]\mathbf{J} 
   \mathsf{K} \Lambda 
   M \aleph \emptyset \Pi \mathit{Q} \Re \Sigma 
[tt]\mathtt{T} 
   \Upsilon \mathcal{V} 
[b]\mathbf{W} 
   \Xi \mathsf{Y} Z 
   \quad 
   a 
[b]\mathbf{c} 
   \epsilon 
[tt]\mathtt{i} 
   \kappa 
[b]\mathbf{m} 
   \nu o \varpi \mathsf{r} 
   s \tau \mathit{u} v \mathsf{w} z 
   \quad 
[tt]\mathtt{g} 
   j \mathsf{q} \chi y 
   \quad 
   b \delta 
[b]\mathbf{f} 
[tt]\mathtt{h} 
   k \mathsf{l} \phi 
\] 

\subsection*{Accents}

\[
\hbox{%
   \'o \`o \^o \"o \~o \=o \.o \u o \v o 
   \H o \t oo \c o \d o \b o \t oo}
   \quad
   \hat o \check o \tilde o \acute o \grave o \dot o 
   \ddot o 
   \breve o \bar o \vec o \vec h \hbar 
\]

\subsection*{Glyph dimensions} 

These glyphs should be optically centered: 
   \testglyphs\sidebearings 
These subscripts should be correctly placed: 
   \testglyphs\subscripts 
These superscripts should be correctly placed: 
   \testglyphs\supscripts 
These subscripts and superscripts should be correctly placed: 
   \testglyphs\scripts 
These accents should be centered: 
   \testglyphs\vecaccents 
As should these: 
   \testglyphs\tildeaccents 

\subsection*{Symbols} 

These arrows should join up properly: 
\[ 
   a \hookrightarrow b \hookleftarrow c \longrightarrow d 
   \longleftarrow e \Longrightarrow f \Longleftarrow g 
   \longleftrightarrow h \Longleftrightarrow i 
   \mapsto j 
\]
\[ 
    g^\circ \mapsto g^\bullet\quad x\equiv y\not\equiv z
\]
These symbols should be of similar weights: 
\[ 
   \pm + - \mp = / \backslash ( \langle [ \{ \} ] \rangle ) < \leq >  \geq 
\] 
Are these the same size? 
\[\textstyle 
   \oint \int \quad 
   \bigodot \bigoplus \bigotimes \sum \prod 
   \bigcup \bigcap \biguplus \bigwedge \bigvee \coprod 
\] 
Are these? 
\[ 
   \oint \int \quad 
   \bigodot \bigoplus \bigotimes \sum \prod 
   \bigcup \bigcap \biguplus \bigwedge \bigvee \coprod 
\] 


\subsection*{Sizing}

\[
    abcde + x^{abcde} + 2^{x^{abcde}}
\] 

The subscripts should be appropriately sized: 
\begin{quote} 
%\testsize\tiny 
%\testsize\scriptsize 
%\testsize\footnotesize 
%\testsize\small 
\testsize\normalsize 
%\testsize\large 
%\testsize\Large 
%\testsize\LARGE 
%\testsize\huge 
%\testsize\Huge 
\end{quote} 

\subsection*{Delimiters} 

Each row should be a different size, but within each row the delimiters 
should be the same size.  First with \verb|\big|, etc: 
\[\begin{array}{c} 
   \testdelims\relax\relax{a} 
   \testdelims\bigl\bigr{a} 
   \testdelims\Bigl\Bigr{a} 
   \testdelims\biggl\biggr{a} 
   \testdelims\Biggl\Biggr{a} 
\end{array}\] 
Then with \verb|\left| and \verb|\right|: 
\[\begin{array}{c} 
   \testdelims\left\right{\begin{array}{c} a \end{array}} 
   \testdelims\left\right{\begin{array}{c} a\\a \end{array}} 
   \testdelims\left\right{\begin{array}{c} a\\a\\a \end{array}} 
   \testdelims\left\right{\begin{array}{c} a\\a\\a\\a \end{array}}  
\end{array}\] 

\subsection*{Spacing} 

This paragraph should appear to be a monotone grey texture.  Suppose
\(f \in \mathcal{S}_n\) and \(g(x) = (-1)^{|\alpha|}x^\alpha
f(x)\).  Then \(g \in \mathcal{S}_n\); now (\emph{c}) implies
that \(\hat g = D_\alpha \hat f\) and \(P \cdot D_\alpha\hat
f = P \cdot \hat g = (P(D)g)\hat{}\), which is a bounded function,
since \(P(D)g \in L^1(R^n)\).  This proves that \(\hat f \in
\mathcal S_n\).  If \(f_i \rightarrow f\) in \(\mathcal S_n\),
then \(f_i \rightarrow f\) in \(L^1(R^n)\).  Therefore \(\hat
f_i(t) \rightarrow \hat f(t)\) for all \(t \in R^n\).  That \(f
\rightarrow \hat f\) is a \emph{continuous} mapping of
\(\mathcal S_n\) into \(\mathcal S_n\) follows now from the
closed graph theorem.  And thus for \(x_1\) through \(x_i\). 
\emph{Functional Analysis}, W.~Rudin,
McGraw--Hill, 1973. 

[b]\begin{boldface}	
[b]This paragraph should appear to be a monotone dark texture.  Suppose
[b]\(f \in \mathcal{S}_n\) and \(g(x) = (-1)^{|\alpha|}x^\alpha
[b]f(x)\).  Then \(g \in \mathcal{S}_n\); now (\emph{c}) implies
[b]that \(\hat g = D_\alpha \hat f\) and \(P \cdot D_\alpha\hat
[b]f = P \cdot \hat g = (P(D)g)\hat{}\), which is a bounded function,
[b]since \(P(D)g \in L^1(R^n)\).  This proves that \(\hat f \in
[b]\mathcal S_n\).  If \(f_i \rightarrow f\) in \(\mathcal S_n\),
[b]then \(f_i \rightarrow f\) in \(L^1(R^n)\).  Therefore \(\hat
[b]f_i(t) \rightarrow \hat f(t)\) for all \(t \in R^n\).  That \(f
[b]\rightarrow \hat f\) is a \emph{continuous} mapping of
[b]\(\mathcal S_n\) into \(\mathcal S_n\) follows now from the
[b]closed graph theorem.  And thus for \(x_1\) through \(x_i\).
[b]\emph{Functional Analysis}, W.~Rudin, McGraw--Hill, 1973. 
[b]\end{boldface}

{\itshape This paragraph should appear to be a monotone grey texture.
Suppose \(f \in \mathcal{S}_n\) and \(g(x) =
(-1)^{|\alpha|}x^\alpha f(x)\).  Then \(g \in \mathcal{S}_n\);
now (\emph{c}) implies that \(\hat g = D_\alpha \hat f\) and
\(P \cdot D_\alpha\hat f = P \cdot \hat g = (P(D)g)\hat{}\),
which is a bounded function, since \(P(D)g \in L^1(R^n)\).  This
proves that \(\hat f \in \mathcal S_n\).  If \(f_i \rightarrow
f\) in \(\mathcal S_n\), then \(f_i \rightarrow f\) in
\(L^1(R^n)\).  Therefore \(\hat f_i(t) \rightarrow \hat f(t)\)
for all \(t \in R^n\).  That \(f \rightarrow \hat f\) is a
\emph{continuous} mapping of \(\mathcal S_n\) into \(\mathcal
S_n\) follows now from the closed graph theorem.  \emph{Functional
Analysis}, W.~Rudin, McGraw--Hill, 1973.}

The text in these boxes should spread out as much as the math does: 
\[\begin{array}{c} 
   \framebox[.95\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
   \framebox[.975\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
   \framebox[\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
   \framebox[1.025\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
   \framebox[1.05\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
   \framebox[1.075\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
   \framebox[1.1\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
   \framebox[1.125\width][s]{For example \(x+y = \min\{x,y\} 
      + \max\{x,y\}\) is a formula.} \\ 
\end{array}\] 
\end{document} 
