/* globals.h - 19:52 GMT +10:00 Wed 12 May 1993 - modified by Geoffrey Tobin */

#ifndef GLOBALS_H
#define GLOBALS_H

#ifndef CONFIG_H
/* typedef for Word, in the appropriate architecture */
#include "config.h"
#endif /* CONFIG_H */

/* Include file ../include/globals.h from dvitovdu.c */


/* Author:         Andrew Trevorrow
   Implementation: Pyramid Pascal

   Description:
   This program allows pages from a DVI file produced by TeX to be previewed
   on a VDU screen.

   Notes:
 - See AAAREAD.ME for revision history.
 - Debugging code is bracketed by { DEBUG } ... { GUBED }.
   This code will be commented out in the final working version.
 - System-dependent code is indicated by the string "SYSDEP".
 - Uncertain code is indicated by the string "???".
 - Unfinished code is indicated by the string "!!!".
 - Goto 999 is used to emulate a RETURN (from procedure) statement.
 - Goto <= 888 is used to emulate an EXIT (from loop) statement.
 - The above notes are also true for all separately compiled modules.
*/


/* Global declarations for DVItoVDU */

/* logfile - defined in dvitovdu.c */

extern FILE * logfile;

#define maxstring       80


typedef Char string[maxstring + 1]; /* Allow space for null terminator */

/* pointer to 32-bit word */

/* The following variant records are needed because Pyramid Pascal
   does not provide type coercion.
   Note that we couldn't overlay INTEGER and BITSET because
   of the crazy storage scheme used to represent a set of 0..31
   where the bit order within a word is 7..0 15..8 23..16 31..24!
*/


typedef union byte_order {
  int int_;
  struct
    {
#ifdef LITTLE_ENDIAN
      char _byte0, _byte1, _byte2, _byte3;
#else /* not LITTLE_ENDIAN */
#ifdef BIG_ENDIAN
      char _byte3, _byte2, _byte1, _byte0;
#else /* not BIG_ENDIAN */
  /* Never heard of something that's neither little- nor big-endian! */
      Configuration error.
#endif /* BIG_ENDIAN */
#endif /* LITTLE_ENDIAN */
      }_bytes;
}byte_order;

#define byte0(lvalue) ((byte_order *)(&lvalue))->_bytes._byte0
#define byte1(lvalue) ((byte_order *)(&lvalue))->_bytes._byte1
#define byte2(lvalue) ((byte_order *)(&lvalue))->_bytes._byte2
#define byte3(lvalue) ((byte_order *)(&lvalue))->_bytes._byte3

typedef struct int_or_bptr
{
  boolean b;
  union
  {
    int int_;
    int * bptr;
  } UU;
} int_or_bptr;

typedef struct int_or_mptr
{
  boolean b;
  union
  {
    int int_;
    Word * mptr;  /* bitmap */
  } UU;
} int_or_mptr;

#endif /* GLOBALS_H */

/* end globals.h */
