/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     October 1999
 * Modified:  January 2002
 *
 */

#include  <stdio.h>
#include  <gtk/gtk.h>

#include  "xbibfile.h"

/* This file is a modified copy of article.c so that it handles the
 * book BibTeX reference style */


GtkWidget  *labelX, *dataX;
GtkWidget  *label0, *data0;
GtkWidget  *label1, *data1;
GtkWidget  *label2, *data2;
GtkWidget  *label3, *data3;
GtkWidget  *label6, *data6;
GtkWidget  *label7, *data7;
GtkWidget  *label12, *data12;
GtkWidget  *label13, *data13, *textscroll;
GtkWidget  *label14, *data14;
GtkWidget  *label17, *data17;
GtkWidget  *label19, *data19;
GtkWidget  *label20, *data20;
GtkWidget  *label22, *data22;
GtkWidget  *label24, *data24;
GtkWidget  *label23, *data23;
GtkWidget  *label24, *data24;
GtkWidget  *label30, *data30;
GtkWidget  *label31, *data31;
GtkWidget  *label32, *data32;
GtkTextBuffer  *text13;
GtkTextIter  start, end;
PangoFontDescription  *font_desc;




/* The procedure to save the book style */

void save_book(GtkWidget *widget)
{
  extern int format;
  extern int length[];
  extern char slate[][];
  extern int lengthX;
  extern char slateX[];
  extern char slate1[];
  extern char slate2[];
  extern char slate3[];
  extern char slate6[];
  extern char slate7[];
  extern char slate12[];
  extern char slate13[];
  extern char slate14[];
  extern char slate17[];
  extern char slate19[];
  extern char slate20[];
  extern char slate23[];
  extern char slate22[];
  extern char slate24[];
  extern char slate30[];
  extern char slate31[];
  extern char slate32[];
  extern  void error();          /* defined in file error.c */
  extern  FILE *finput;          /* defined in file xbibfile.c */
  extern  void close_window();   /* defined in file cleanup.c */

  if (format != 2) {
    error(widget, GINT_TO_POINTER(5));
    return;
  }
  strcpy(slateX, gtk_entry_get_text(GTK_ENTRY(dataX)));
  lengthX = strlen(slateX);
  strcpy(slate3, gtk_entry_get_text(GTK_ENTRY(data3)));
  length[3] = strlen(slate3);
  strcpy(slate7, gtk_entry_get_text(GTK_ENTRY(data7)));
  length[7] = strlen(slate7);
  strcpy(slate20, gtk_entry_get_text(GTK_ENTRY(data20)));
  length[20] = strlen(slate20);
  strcpy(slate17, gtk_entry_get_text(GTK_ENTRY(data17)));
  length[17] = strlen(slate17);
  strcpy(slate24, gtk_entry_get_text(GTK_ENTRY(data24)));
  length[24] = strlen(slate24);
  if (!((length[3] || length[7])
            && length[20] && length[17] && length[24] && lengthX)) {
    error(widget, GINT_TO_POINTER(3));
    return;
  }
  if (!finput) {
    error(widget, GINT_TO_POINTER(8));
    return;
  }
  /*  finput = stdout; */
  fprintf(finput, "\n@BOOK{%s,\n", slateX);
  if (length[3])  fprintf(finput, "   author = {%s},\n", slate3);
  if (length[7])  fprintf(finput, "   editor = {%s},\n", slate7);
  fprintf(finput, "   title = {%s},\n", slate20);
  fprintf(finput, "   publisher = {%s},\n", slate17);
  fprintf(finput, "   year = {%s}", slate24);
  if (length[23])
    fprintf(finput, ",\n   volume = {%s}", slate23);
  if (length[14])
    fprintf(finput, ",\n   number = {%s}", slate14);
  if (length[19])
    fprintf(finput, ",\n   series = {%s}", slate19);
  if (length[1])
    fprintf(finput, ",\n   address = {%s}", slate1);
  if (length[6])
    fprintf(finput, ",\n   edition = {%s}", slate6);
  if (length[12])
    fprintf(finput, ",\n   month = {%s}", slate12);
  if (length[22])
    fprintf(finput, ",\n   URL = {%s}", slate22);
  if (length[2])
    fprintf(finput, ",\n   note = {%s}", slate2);
  if (length[13])
      fprintf(finput, ",\n   annote = {%s}", slate13);
  if (length[30])
    fprintf(finput, ",\n   uplink = {%s}", slate30);
  if (length[31])
    fprintf(finput, ",\n   crosslink = {%s}", slate31);
  if (length[32])
    fprintf(finput, ",\n   externlink = {%s}", slate32);
  fprintf(finput, " }\n");
                      /* indicate that the reference is saved */
  format = 0;
  length[1] = 0;
  length[2] = 0;
  length[6] = 0;
  length[12] = 0;
  length[13] = 0;
  length[14] = 0;
  length[19] = 0;
  length[22] = 0;
  length[23] = 0;
  length[30] = 0;
  length[31] = 0;
  length[32] = 0;
  close_window(widget);   /* remove this reference window */
}


/* Save the book optional fields for subsequent saving */

void  save_bookoptions(GtkWidget *widget)
{
  extern  void close_window();
  extern  int length[];
  extern  char slate1[];
  extern  char slate2[];
  extern  char slate6[];
  extern  char slate12[];
  extern  char slate13[];
  extern  char slate14[];
  extern  char slate19[];
  extern  char slate22[];
  extern  char slate23[];
  char  *text_in_field;
  int   count;

  strcpy(slate1, gtk_entry_get_text(GTK_ENTRY(data1)));
  length[1] = strlen(slate1);
  strcpy(slate6, gtk_entry_get_text(GTK_ENTRY(data6)));
  length[6] = strlen(slate6);
  strcpy(slate12, gtk_entry_get_text(GTK_ENTRY(data12)));
  length[12] = strlen(slate12);
  strcpy(slate14, gtk_entry_get_text(GTK_ENTRY(data14)));
  length[14] = strlen(slate14);
  strcpy(slate19, gtk_entry_get_text(GTK_ENTRY(data19)));
  length[19] = strlen(slate19);
  strcpy(slate23, gtk_entry_get_text(GTK_ENTRY(data23)));
  length[23] = strlen(slate23);
  strcpy(slate22, gtk_entry_get_text(GTK_ENTRY(data22)));
  length[22] = strlen(slate22);
  strcpy(slate2, gtk_entry_get_text(GTK_ENTRY(data2)));
  length[2] = strlen(slate2);
  count = gtk_text_buffer_get_char_count(text13);
  gtk_text_buffer_get_iter_at_offset(text13, &end, count);
  gtk_text_buffer_get_iter_at_offset(text13, &start, 0);
  strcpy(slate13, gtk_text_buffer_get_text(text13, &start, &end, FALSE)); 
  length[13] = count;

  close_window(widget);
}
 



/* Close the option entry window, but first delete the entries */

void  close_bookoptions(GtkWidget *widget)
{
  extern  void  close_window();
  extern  int length[];

  length[23] = 0;
  length[22] = 0;
  length[19] = 0;
  length[14] = 0;
  length[13] = 0;
  length[12] = 0;  
  length[6] = 0;  
  length[2] = 0;  
  length[1] = 0;  
  close_window(widget);
}


/* The procedure to put the optional book style fields on the screen */

void bookoptions(GtkWidget *widget)
{
  extern  int format;
  GtkTooltips *tooltips;
  GtkWidget  *window;
  GtkWidget  *decoration;
  GtkWidget  *totalPane;
  GtkWidget  *field0;
  GtkWidget  *field1;
  GtkWidget  *field2;
  GtkWidget  *field3;
  GtkWidget  *field4;
  GtkWidget  *field5;
  GtkWidget  *field6;
  GtkWidget  *field7;
  GtkWidget  *field8;
  GtkWidget  *key0;
  GtkWidget  *key1;

  void close_bookoptions();
  void save_bookoptions();

  if (format == 0) {
    error (widget, GINT_TO_POINTER(6));
    return;
  }

                    /* create the tooltip help feature */

  tooltips = gtk_tooltips_new();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile create");
  gtk_widget_set_usize(GTK_WIDGET(window), 400, 635);
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  decoration = gtk_frame_new("Optional book fields");
  gtk_container_add(GTK_CONTAINER(window), decoration);
  totalPane = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(decoration), totalPane);

                         /* put the text fields in place */
  field1 = gtk_hbox_new(FALSE, 0);
  data23 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data23), TINY);
  label23 = gtk_label_new("|| Volume:");
  gtk_widget_set_usize(GTK_WIDGET(label23), 75, -1);
  gtk_box_pack_start(GTK_BOX(field1), label23, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field1), data23, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field1, FALSE, TRUE, 10);

  field2 = gtk_hbox_new(FALSE, 0);
  data14 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data14), TINY);
  label14 = gtk_label_new("|| Number:");
  gtk_widget_set_usize(GTK_WIDGET(label14), 75, -1);
  gtk_box_pack_start(GTK_BOX(field2), label14, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field2), data14, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field2, FALSE, TRUE, 2);

  field3 = gtk_hbox_new(FALSE, 0);
  data19 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data19), SMALL);
  label19 = gtk_label_new("Series:");
  gtk_widget_set_usize(GTK_WIDGET(label19), 75, -1);
  gtk_box_pack_start(GTK_BOX(field3), label19, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field3), data19, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field3, FALSE, TRUE, 2);

  field4 = gtk_hbox_new(FALSE, 0);
  data1 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data1), LARGE);
  label1 = gtk_label_new("Address:");
  gtk_widget_set_usize(GTK_WIDGET(label1), 75, -1);
  gtk_box_pack_start(GTK_BOX(field4), label1, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field4), data1, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field4, FALSE, TRUE, 2);

  field5 = gtk_hbox_new(FALSE, 0);
  data6 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data6), SMALL);
  label6 = gtk_label_new("Edition:");
  gtk_widget_set_usize(GTK_WIDGET(label6), 75, -1);
  gtk_box_pack_start(GTK_BOX(field5), label6, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field5), data6, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field5, FALSE, TRUE, 2);

  field6 = gtk_hbox_new(FALSE, 0);
  data12 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data12), TINY);
  label12 = gtk_label_new("Month:");
  gtk_widget_set_usize(GTK_WIDGET(label12), 75, -1);
  gtk_box_pack_start(GTK_BOX(field6), label12, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field6), data12, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field6, FALSE, TRUE, 2);

  field7 = gtk_hbox_new(FALSE, 0);
  data22 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data22), LARGE);
  label22 = gtk_label_new("URL:");
  gtk_widget_set_usize(GTK_WIDGET(label22), 75, -1);
  gtk_box_pack_start(GTK_BOX(field7), label22, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field7), data22, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field7, FALSE, TRUE, 2);

  field8 = gtk_hbox_new(FALSE, 0);
  data2 = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(data2), LARGE);
  label2 = gtk_label_new("note:");
  gtk_widget_set_usize(GTK_WIDGET(label2), 75, -1);
  gtk_box_pack_start(GTK_BOX(field8), label2, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field8), data2, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field8, FALSE, TRUE, 2);

  text13 = gtk_text_buffer_new(NULL);
  data13 = gtk_text_view_new_with_buffer(text13);
  textscroll = gtk_scrolled_window_new(NULL, NULL);
  font_desc = pango_font_description_from_string("Sans 12");
  gtk_widget_modify_font(data13, font_desc);
  gtk_container_add(GTK_CONTAINER(textscroll), data13);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(textscroll),
                                 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(GTK_WIDGET(data13), 30, 250);
  label13 = gtk_label_new("Annotation:");
  gtk_box_pack_start(GTK_BOX(totalPane), label13, FALSE, TRUE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), textscroll, FALSE, TRUE, 2);

                          /* finally, put the cancel button in place */
  field0 = gtk_hbox_new(FALSE, 0);
  key0 = gtk_button_new_with_label("CANCEL");
  gtk_widget_set_usize(GTK_WIDGET(key0), 90, -1);
  g_signal_connect(GTK_OBJECT(key0), "clicked",
                   G_CALLBACK(close_bookoptions), NULL);
  gtk_tooltips_set_tip(tooltips, key0,
                       "Discard the contents of this window", NULL);
  gtk_box_pack_end(GTK_BOX(field0), key0, FALSE, FALSE, 10);
  key1 = gtk_button_new_with_label("Save");
  gtk_widget_set_usize(GTK_WIDGET(key1), 90, -1);
  g_signal_connect(GTK_OBJECT(key1), "clicked",
                   G_CALLBACK(save_bookoptions), NULL);
  gtk_tooltips_set_tip(tooltips, key1,
                       "Store the contents of this window", NULL);
  gtk_box_pack_end(GTK_BOX(field0), key1, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field0, FALSE, TRUE, 10);

                         /* put the composite window on the screen */
  gtk_widget_show_all(window);
}



/* The procedure to put the basic book style on the screen */

void book(GtkWidget *widget)
{
  GtkTooltips *tooltips;
  GtkWidget  *window;
  GtkWidget  *decoration;
  GtkWidget  *totalPane;
  GtkWidget  *opDecoration;
  GtkWidget  *field0;
  GtkWidget  *field1;
  GtkWidget  *option;
  GtkWidget  *controls;
  GtkWidget  *key1;
  GtkWidget  *key2;
  GtkWidget  *key3;
  GtkWidget  *key4;
  GtkWidget  *field2;
  GtkWidget  *field3;
  GtkWidget  *field4; 
  GtkWidget  *field5;
  GtkWidget  *field6;
  extern int  format;
  extern char slate0[];

  extern  void linkwindow();
  extern void closure_check();    /* defined in file cleanup.c */
  extern void close_window();   /* defined in file cleanup.c */
  void  bookoptions();

                         /* create the tooltip help feature */

  tooltips = gtk_tooltips_new();

  format = 2;            /* indicate processing of an BOOK */

                         /* create the wondow and its top panel */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile create");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  decoration = gtk_frame_new("Book type - required fields");
  gtk_widget_set_usize(GTK_WIDGET(window), 450, 355);
  gtk_container_add(GTK_CONTAINER(window), decoration);
  totalPane = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(decoration), totalPane);

  field1 = gtk_hbox_new(FALSE,0);
  dataX = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(dataX), SMALL);
  gtk_widget_set_usize(GTK_WIDGET(dataX), 345, -1);
  labelX = gtk_label_new("Tag/s:");
  gtk_widget_set_usize(GTK_WIDGET(labelX), 65, -1);
  gtk_box_pack_start(GTK_BOX(field1), labelX, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field1), dataX, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field1, FALSE, TRUE, 10);

  field0 = gtk_hbox_new(FALSE, 0);
  data0 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data0), 345, -1);
  label0 = gtk_label_new("File used:");
  gtk_widget_set_usize(GTK_WIDGET(label0), 65, -1);
  gtk_entry_set_text(GTK_ENTRY(data0), slate0);
  gtk_box_pack_start(GTK_BOX(field0), label0, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field0), data0, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field0, FALSE, TRUE, 2);

                         /* position the remaining field entries */
  field2 = gtk_hbox_new(FALSE, 0);
  data3 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data3), 345, -1);
  label3 = gtk_label_new("|| Authors/s:");
  gtk_widget_set_usize(GTK_WIDGET(label3), 65, -1);
  gtk_box_pack_start(GTK_BOX(field2), label3, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field2), data3, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field2, FALSE, TRUE, 2);

  field3 = gtk_hbox_new(FALSE, 0);
  data7 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data7), 345, -1);
  label7 = gtk_label_new("|| Editors/s:");
  gtk_widget_set_usize(GTK_WIDGET(label7), 65, -1);
  gtk_box_pack_start(GTK_BOX(field3), label7, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field3), data7, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field3, FALSE, TRUE, 2);

  field4 = gtk_hbox_new(FALSE, 0);
  data20 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data20), 345, -1);
  label20 = gtk_label_new("Title:");
  gtk_widget_set_usize(GTK_WIDGET(label20), 65, -1);
  gtk_box_pack_start(GTK_BOX(field4), label20, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field4), data20, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field4, FALSE, TRUE, 2);

  field5 = gtk_hbox_new(FALSE, 0);
  data17 = gtk_entry_new_with_max_length(LARGE);
  gtk_widget_set_usize(GTK_WIDGET(data17), 345, -1);
  label17 = gtk_label_new("Publisher:");
  gtk_widget_set_usize(GTK_WIDGET(label17), 65, -1);
  gtk_box_pack_start(GTK_BOX(field5), label17, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field5), data17, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field5, FALSE, TRUE, 2);

  field6 = gtk_hbox_new(FALSE, 0);
  data24 = gtk_entry_new_with_max_length(SMALL);
  gtk_widget_set_usize(GTK_WIDGET(data24), 200, -1);
  label24 = gtk_label_new("Year:");
  gtk_widget_set_usize(GTK_WIDGET(label24), 65, -1);
  gtk_box_pack_start(GTK_BOX(field6), label24, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(field6), data24, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field6, FALSE, TRUE, 2);

                         /* put the control keys on to the window */
  option = gtk_hbox_new(FALSE, 0);
  key2 = gtk_button_new_with_label("Optional fields");
  gtk_widget_set_usize(GTK_WIDGET(key2), 130, -1);
  g_signal_connect(GTK_OBJECT(key2), "clicked",
                   G_CALLBACK(bookoptions), NULL);
  gtk_tooltips_set_tip(tooltips, key2,
                "Click here to get window containing remaining Book fields",
                       NULL);
  gtk_box_pack_start(GTK_BOX(option), key2, FALSE, FALSE, 10);
  controls = gtk_hbox_new(FALSE, 0);
  key1 = gtk_button_new_with_label("Save");
  gtk_widget_set_usize(GTK_WIDGET(key1), 90, -1);
  g_signal_connect(GTK_OBJECT(key1), "clicked",
                   G_CALLBACK(save_book), NULL);
  gtk_tooltips_set_tip(tooltips, key1,
                       "Store this Book reference in database", NULL);
  gtk_box_pack_start(GTK_BOX(controls), key1, FALSE, FALSE, 30);
 key3 = gtk_button_new_with_label("Cancel");
  gtk_widget_set_usize(GTK_WIDGET(key3), 90, -1);
  g_signal_connect(GTK_OBJECT(key3), "clicked",
                   G_CALLBACK(closure_check), NULL);
  gtk_tooltips_set_tip(tooltips, key3,
                       "Discard this Book entry", NULL);
  gtk_box_pack_start(GTK_BOX(controls), key3, FALSE, FALSE, 30);
  key4 = gtk_button_new_with_label("Linking");
  gtk_widget_set_usize(GTK_WIDGET(key4), 90, -1);
  g_signal_connect(GTK_OBJECT(key4), "clicked",
                   G_CALLBACK(linkwindow), NULL);
  gtk_tooltips_set_tip(tooltips, key4,
                      "Click here for window to create links for this Book",
                        NULL);
  gtk_box_pack_start(GTK_BOX(controls), key4, FALSE, FALSE, 30);
  gtk_box_pack_start(GTK_BOX(totalPane), option, FALSE, TRUE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), controls, FALSE, TRUE, 10);


  format = 2;

                         /* make the composite visible on screen */
  gtk_widget_show_all(window);
}
